/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class RsaKeyReader {
    /*
     * Enabled aggressive exception aggregation
     */
    public static KeyPair read(Path publicKeyPath, Path privateKeyPath) {
        try (InputStream publicKeyIn = Files.newInputStream(publicKeyPath, new OpenOption[0]);){
            KeyPair keyPair;
            block14: {
                InputStream privateKeyIn = Files.newInputStream(privateKeyPath, new OpenOption[0]);
                try {
                    keyPair = RsaKeyReader.read(publicKeyIn, privateKeyIn);
                    if (privateKeyIn == null) break block14;
                }
                catch (Throwable throwable) {
                    if (privateKeyIn != null) {
                        try {
                            privateKeyIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                privateKeyIn.close();
            }
            return keyPair;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't read RSA key pair paths", e);
        }
    }

    static KeyPair read(InputStream publicKeyIn, InputStream privateKeyIn) {
        try {
            PublicKey publicKey = RsaKeyReader.readPublicKey(publicKeyIn);
            PrivateKey privateKey = RsaKeyReader.readPrivateKey(privateKeyIn);
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException("Couldn't read RSA key pair", e);
        }
    }

    private static PublicKey readPublicKey(InputStream in) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] pemContent = RsaKeyReader.readPemContent(new InputStreamReader(in));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pemContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(keySpec);
    }

    private static PrivateKey readPrivateKey(InputStream in) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] pemContent = RsaKeyReader.readPemContent(new InputStreamReader(in));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pemContent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    private static byte[] readPemContent(Reader reader) {
        byte[] byArray;
        PemReader pemReader = new PemReader(reader);
        try {
            PemObject pemObject = pemReader.readPemObject();
            if (Objects.isNull(pemObject)) {
                throw new IllegalArgumentException("Couldn't read PEM file");
            }
            byArray = pemObject.getContent();
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Couldn't read PEM file", e);
            }
        }
        pemReader.close();
        return byArray;
    }
}

