/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.security;

import io.aiven.kafka.tieredstorage.security.EncryptedDataKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class RsaEncryptionProvider {
    private static final String RSA_TRANSFORMATION = "RSA/NONE/OAEPWithSHA3-512AndMGF1Padding";
    private final String activeKeyId;
    private final Map<String, KeyPair> keyring;
    private final PublicKey encryptionPublicKey;

    public RsaEncryptionProvider(String activeKeyId, Map<String, KeyPair> keyring) {
        this.activeKeyId = Objects.requireNonNull(activeKeyId, "keyId cannot be null");
        this.keyring = Objects.requireNonNull(keyring, "keyring cannot be null");
        this.encryptionPublicKey = keyring.get(activeKeyId).getPublic();
        if (this.encryptionPublicKey == null) {
            throw new IllegalArgumentException("Key ID " + activeKeyId + " is not in keyring");
        }
    }

    public EncryptedDataKey encryptDataKey(byte[] dataKey) {
        try {
            Cipher cipher = this.createEncryptingCipher(this.encryptionPublicKey);
            return new EncryptedDataKey(this.activeKeyId, cipher.doFinal(dataKey));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Couldn't encrypt AES key", e);
        }
    }

    private Cipher createEncryptingCipher(Key key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION, "BC");
            cipher.init(1, key, SecureRandom.getInstanceStrong());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException("Couldn't create encrypt cipher", e);
        }
    }

    public byte[] decryptDataKey(EncryptedDataKey encryptedKeyString) {
        try {
            KeyPair keyPair = this.keyring.get(encryptedKeyString.keyEncryptionKeyId);
            if (keyPair == null) {
                throw new IllegalArgumentException("Unknown key " + encryptedKeyString.keyEncryptionKeyId);
            }
            Cipher cipher = this.createDecryptingCipher(keyPair.getPrivate());
            return cipher.doFinal(encryptedKeyString.encryptedDataKey);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Couldn't decrypt AES key", e);
        }
    }

    private Cipher createDecryptingCipher(Key key) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION, "BC");
            cipher.init(2, key, SecureRandom.getInstanceStrong());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException("Couldn't create decrypt cipher", e);
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

