/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.security;

import java.util.Base64;
import java.util.Objects;

public class EncryptedDataKey {
    public final String keyEncryptionKeyId;
    public final byte[] encryptedDataKey;

    public EncryptedDataKey(String keyEncryptionKeyId, byte[] encryptedDataKey) {
        this.keyEncryptionKeyId = Objects.requireNonNull(keyEncryptionKeyId, "keyEncryptionKeyId cannot be null");
        if (keyEncryptionKeyId.isBlank()) {
            throw new IllegalArgumentException("keyEncryptionKeyId cannot be blank");
        }
        this.encryptedDataKey = Objects.requireNonNull(encryptedDataKey, "encryptedDataKey cannot be null");
        if (this.encryptedDataKey.length == 0) {
            throw new IllegalArgumentException("encryptedDataKey cannot be empty");
        }
    }

    public static EncryptedDataKey parse(String keyText) {
        int colonI = keyText.indexOf(58);
        if (colonI < 0) {
            throw new IllegalArgumentException("Malformed encrypted data key string: " + keyText);
        }
        int lastColonI = keyText.lastIndexOf(58);
        if (lastColonI != colonI) {
            throw new IllegalArgumentException("Malformed encrypted data key string: " + keyText);
        }
        String keyEncryptionKeyId = keyText.substring(0, colonI);
        String dataKeyBase64 = keyText.substring(colonI + 1);
        try {
            byte[] decoded = Base64.getDecoder().decode(dataKeyBase64);
            return new EncryptedDataKey(keyEncryptionKeyId, decoded);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Malformed encrypted data key string: " + keyText, e);
        }
    }

    public String serialize() {
        return this.keyEncryptionKeyId + ":" + Base64.getEncoder().encodeToString(this.encryptedDataKey);
    }

    public String toString() {
        return "EncryptedDataKey(" + this.serialize() + ")";
    }
}

