/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.security;

import io.aiven.kafka.tieredstorage.manifest.SegmentEncryptionMetadata;
import io.aiven.kafka.tieredstorage.security.DataKeyAndAAD;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class AesEncryptionProvider {
    public static final int KEY_SIZE = 256;
    public static final int GCM_TAG_LENGTH = 128;
    public static final String AES_TRANSFORMATION = "AES/GCM/NoPadding";
    private final KeyGenerator aesKeyGenerator;

    public AesEncryptionProvider() {
        try {
            this.aesKeyGenerator = KeyGenerator.getInstance("AES");
            this.aesKeyGenerator.init(256, SecureRandom.getInstanceStrong());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public DataKeyAndAAD createDataKeyAndAAD() {
        SecretKey dataKey = this.aesKeyGenerator.generateKey();
        byte[] aad = this.aesKeyGenerator.generateKey().getEncoded();
        return new DataKeyAndAAD(dataKey, aad);
    }

    public Cipher encryptionCipher(DataKeyAndAAD dataKeyAndAAD) {
        Cipher encryptCipher = this.createEncryptingCipher(dataKeyAndAAD.dataKey);
        encryptCipher.updateAAD(dataKeyAndAAD.aad);
        return encryptCipher;
    }

    private Cipher createEncryptingCipher(Key key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION);
            cipher.init(1, key, SecureRandom.getInstanceStrong());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Couldn't create encrypt cipher", e);
        }
    }

    public Cipher decryptionCipher(byte[] encryptedChunk, SegmentEncryptionMetadata encryptionMetadata) {
        GCMParameterSpec params = new GCMParameterSpec(128, encryptedChunk, 0, encryptionMetadata.ivSize());
        Cipher encryptCipher = this.createDecryptingCipher(encryptionMetadata.dataKey(), params);
        encryptCipher.updateAAD(encryptionMetadata.aad());
        return encryptCipher;
    }

    private Cipher createDecryptingCipher(Key key, AlgorithmParameterSpec params) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(params, "params cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION);
            cipher.init(2, key, params, SecureRandom.getInstanceStrong());
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Couldn't create decrypt cipher", e);
        }
    }
}

