/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import java.util.List;
import org.apache.kafka.common.MetricNameTemplate;

public class ThreadPoolMonitorMetricsRegistry {
    public static final String METRIC_CONFIG = "aiven.kafka.server.tieredstorage.thread-pool";
    static final String ACTIVE_THREADS = "active-thread-count";
    static final String ACTIVE_THREADS_TOTAL = "active-thread-count-total";
    static final String ACTIVE_THREADS_TOTAL_DOC = "Number of threads currently executing tasks";
    static final String RUNNING_THREADS = "running-thread-count";
    static final String RUNNING_THREADS_TOTAL = "running-thread-count-total";
    static final String RUNNING_THREADS_TOTAL_DOC = "Number of worker threads that are not blocked waiting to join tasks or for other managed synchronization";
    static final String POOL_SIZE = "pool-size";
    static final String POOL_SIZE_TOTAL = "pool-size-total";
    static final String POOL_SIZE_TOTAL_DOC = "Current number of threads in the pool";
    static final String PARALLELISM = "parallelism";
    static final String PARALLELISM_TOTAL = "parallelism-total";
    static final String PARALLELISM_TOTAL_DOC = "Targeted parallelism level of the pool";
    static final String QUEUED_TASK_COUNT = "queued-task-count";
    static final String QUEUED_TASK_COUNT_TOTAL = "queued-task-count-total";
    static final String QUEUED_TASK_COUNT_TOTAL_DOC = "Tasks submitted to the pool that have not yet begun executing.";
    static final String STEAL_TASK_COUNT = "steal-task-count";
    static final String STEAL_TASK_COUNT_TOTAL = "steal-task-count-total";
    static final String STEAL_TASK_COUNT_TOTAL_DOC = "Number of tasks stolen from one thread's work queue by another";
    final String groupName;
    final MetricNameTemplate activeThreadsTotalMetricName;
    final MetricNameTemplate runningThreadsTotalMetricName;
    final MetricNameTemplate poolSizeTotalMetricName;
    final MetricNameTemplate parallelismTotalMetricName;
    final MetricNameTemplate queuedTaskCountTotalMetricName;
    final MetricNameTemplate stealTaskCountTotalMetricName;

    public ThreadPoolMonitorMetricsRegistry(String groupName) {
        this.groupName = groupName;
        this.activeThreadsTotalMetricName = new MetricNameTemplate(ACTIVE_THREADS_TOTAL, groupName, ACTIVE_THREADS_TOTAL_DOC, new String[0]);
        this.runningThreadsTotalMetricName = new MetricNameTemplate(RUNNING_THREADS_TOTAL, groupName, RUNNING_THREADS_TOTAL_DOC, new String[0]);
        this.poolSizeTotalMetricName = new MetricNameTemplate(POOL_SIZE_TOTAL, groupName, POOL_SIZE_TOTAL_DOC, new String[0]);
        this.parallelismTotalMetricName = new MetricNameTemplate(PARALLELISM_TOTAL, groupName, PARALLELISM_TOTAL_DOC, new String[0]);
        this.queuedTaskCountTotalMetricName = new MetricNameTemplate(QUEUED_TASK_COUNT_TOTAL, groupName, QUEUED_TASK_COUNT_TOTAL_DOC, new String[0]);
        this.stealTaskCountTotalMetricName = new MetricNameTemplate(STEAL_TASK_COUNT_TOTAL, groupName, STEAL_TASK_COUNT_TOTAL_DOC, new String[0]);
    }

    public List<MetricNameTemplate> all() {
        return List.of(this.activeThreadsTotalMetricName, this.runningThreadsTotalMetricName, this.poolSizeTotalMetricName, this.parallelismTotalMetricName, this.queuedTaskCountTotalMetricName, this.stealTaskCountTotalMetricName);
    }
}

