/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import io.aiven.kafka.tieredstorage.metrics.MeasurableValue;
import io.aiven.kafka.tieredstorage.metrics.SensorProvider;
import io.aiven.kafka.tieredstorage.metrics.ThreadPoolMonitorMetricsRegistry;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class ThreadPoolMonitor {
    final ForkJoinPool pool;
    private final Metrics metrics;
    String groupName;

    public ThreadPoolMonitor(String groupName, ExecutorService pool) {
        this.groupName = groupName;
        if (!(pool instanceof ForkJoinPool)) {
            throw new UnsupportedOperationException("Only ForkJoinPool supported at the moment.");
        }
        this.pool = (ForkJoinPool)pool;
        JmxReporter reporter = new JmxReporter();
        this.metrics = new Metrics(new MetricConfig(), List.of(reporter), Time.SYSTEM, new KafkaMetricsContext("aiven.kafka.server.tieredstorage.thread-pool"));
        ThreadPoolMonitorMetricsRegistry metricsRegistry = new ThreadPoolMonitorMetricsRegistry(groupName);
        this.registerSensor(metricsRegistry.activeThreadsTotalMetricName, "active-thread-count", this::activeThreadCount);
        this.registerSensor(metricsRegistry.runningThreadsTotalMetricName, "running-thread-count", this::runningThreadCount);
        this.registerSensor(metricsRegistry.poolSizeTotalMetricName, "pool-size", this::poolSize);
        this.registerSensor(metricsRegistry.parallelismTotalMetricName, "parallelism", this::parallelism);
        this.registerSensor(metricsRegistry.queuedTaskCountTotalMetricName, "queued-task-count", this::queuedTaskCount);
        this.registerSensor(metricsRegistry.stealTaskCountTotalMetricName, "steal-task-count", this::stealTaskCount);
    }

    void registerSensor(MetricNameTemplate metricName, String sensorName, Supplier<Long> supplier) {
        new SensorProvider(this.metrics, sensorName).with(metricName, new MeasurableValue(supplier)).get();
    }

    long activeThreadCount() {
        return this.pool.getActiveThreadCount();
    }

    long runningThreadCount() {
        return this.pool.getRunningThreadCount();
    }

    long poolSize() {
        return this.pool.getPoolSize();
    }

    long parallelism() {
        return this.pool.getParallelism();
    }

    long queuedTaskCount() {
        return this.pool.getQueuedTaskCount();
    }

    long stealTaskCount() {
        return this.pool.getStealCount();
    }
}

