/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;

public class SensorProvider {
    private final Metrics metrics;
    private final Sensor sensor;
    private final boolean preexisting;
    private final Map<String, String> tags;

    public SensorProvider(Metrics metrics, String name) {
        this(metrics, name, Collections::emptyMap, Sensor.RecordingLevel.INFO);
    }

    public SensorProvider(Metrics metrics, String name, Sensor.RecordingLevel recordingLevel) {
        this(metrics, name, Collections::emptyMap, recordingLevel);
    }

    public SensorProvider(Metrics metrics, String name, Supplier<Map<String, String>> tagsSupplier) {
        this(metrics, name, tagsSupplier, Sensor.RecordingLevel.INFO);
    }

    public SensorProvider(Metrics metrics, String name, Supplier<Map<String, String>> tagsSupplier, Sensor.RecordingLevel recordingLevel) {
        this.metrics = metrics;
        Sensor s = metrics.getSensor(name);
        if (s != null) {
            this.sensor = s;
            this.tags = Collections.emptyMap();
            this.preexisting = true;
        } else {
            this.sensor = metrics.sensor(name, recordingLevel);
            this.tags = tagsSupplier.get();
            this.preexisting = false;
        }
    }

    public SensorProvider with(MetricNameTemplate name, MeasurableStat stat) {
        if (!this.preexisting) {
            this.sensor.add(this.metrics.metricInstance(name, this.tags), stat);
        }
        return this;
    }

    public Sensor get() {
        return this.sensor;
    }
}

