/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import io.aiven.kafka.tieredstorage.ObjectKeyFactory;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;

public class MetricsRegistry {
    public static final String METRIC_CONTEXT = "aiven.kafka.server.tieredstorage";
    static final String METRIC_GROUP = "remote-storage-manager-metrics";
    static final String TAG_NAME_OBJECT_TYPE = "object-type";
    static final String[] OBJECT_TYPE_TAG_NAMES = new String[]{"object-type"};
    static final String TAG_NAME_TOPIC = "topic";
    static final String[] TOPIC_TAG_NAMES = new String[]{"topic"};
    static final String[] TOPIC_OBJECT_TYPE_TAG_NAMES = new String[]{"topic", "object-type"};
    static final String TAG_NAME_PARTITION = "partition";
    static final String[] TOPIC_PARTITION_TAG_NAMES = new String[]{"topic", "partition"};
    static final String[] TOPIC_PARTITION_OBJECT_TYPE_TAG_NAMES = new String[]{"topic", "partition", "object-type"};
    private static final String RATE_DOC_PREFIX = "Rate of ";
    private static final String TOTAL_DOC_PREFIX = "Total number of ";
    private static final String AVG_DOC_PREFIX = "Average ";
    private static final String MAX_DOC_PREFIX = "Maximum ";
    private static final String BY_TOPIC_DOC_SUFFIX = " tagged by topic";
    private static final String BY_TOPIC_PARTITION_DOC_SUFFIX = " tagged by topic and partition";
    private static final String BY_OBJECT_TYPE_DOC_SUFFIX = " tagged by object type";
    private static final String BY_TOPIC_OBJECT_TYPE_DOC_SUFFIX = " tagged by topic and object type";
    private static final String BY_TOPIC_PARTITION_OBJECT_TYPE_DOC_SUFFIX = " tagged by topic, partition and object type";
    static final String SEGMENT_COPY = "segment-copy";
    static final String SEGMENT_COPY_TIME = "segment-copy-time";
    static final String SEGMENT_COPY_TIME_DOC = "time spent processing and uploading a log segment and indexes";
    static final String SEGMENT_COPY_TIME_AVG = "segment-copy-time-avg";
    final MetricNameTemplate segmentCopyTimeAvg = new MetricNameTemplate("segment-copy-time-avg", "remote-storage-manager-metrics", "Average time spent processing and uploading a log segment and indexes", new String[0]);
    final MetricNameTemplate segmentCopyTimeAvgByTopic = new MetricNameTemplate("segment-copy-time-avg", "remote-storage-manager-metrics", "Average time spent processing and uploading a log segment and indexes tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentCopyTimeAvgByTopicPartition = new MetricNameTemplate("segment-copy-time-avg", "remote-storage-manager-metrics", "Average time spent processing and uploading a log segment and indexes tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_COPY_TIME_MAX = "segment-copy-time-max";
    final MetricNameTemplate segmentCopyTimeMax = new MetricNameTemplate("segment-copy-time-max", "remote-storage-manager-metrics", "Maximum time spent processing and uploading a log segment and indexes", new String[0]);
    final MetricNameTemplate segmentCopyTimeMaxByTopic = new MetricNameTemplate("segment-copy-time-max", "remote-storage-manager-metrics", "Maximum time spent processing and uploading a log segment and indexes tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentCopyTimeMaxByTopicPartition = new MetricNameTemplate("segment-copy-time-max", "remote-storage-manager-metrics", "Maximum time spent processing and uploading a log segment and indexes tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE = "segment-delete";
    static final String SEGMENT_DELETE_RATE = "segment-delete-rate";
    static final String SEGMENT_DELETE_DOC = "delete remote segment operations, including all its objects";
    final MetricNameTemplate segmentDeleteRequestsRate = new MetricNameTemplate("segment-delete-rate", "remote-storage-manager-metrics", "Rate of delete remote segment operations, including all its objects", new String[0]);
    final MetricNameTemplate segmentDeleteRequestsRateByTopic = new MetricNameTemplate("segment-delete-rate", "remote-storage-manager-metrics", "Rate of delete remote segment operations, including all its objects tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteRequestsRateByTopicPartition = new MetricNameTemplate("segment-delete-rate", "remote-storage-manager-metrics", "Rate of delete remote segment operations, including all its objects tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_TOTAL = "segment-delete-total";
    final MetricNameTemplate segmentDeleteRequestsTotal = new MetricNameTemplate("segment-delete-total", "remote-storage-manager-metrics", "Total number of delete remote segment operations, including all its objects", new String[0]);
    final MetricNameTemplate segmentDeleteRequestsTotalByTopic = new MetricNameTemplate("segment-delete-total", "remote-storage-manager-metrics", "Total number of delete remote segment operations, including all its objects tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteRequestsTotalByTopicPartition = new MetricNameTemplate("segment-delete-total", "remote-storage-manager-metrics", "Total number of delete remote segment operations, including all its objects tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_BYTES = "segment-delete-bytes";
    static final String SEGMENT_DELETE_BYTES_DOC = "deleted number of bytes estimated from segment size";
    static final String SEGMENT_DELETE_BYTES_RATE = "segment-delete-bytes-rate";
    final MetricNameTemplate segmentDeleteBytesRate = new MetricNameTemplate("segment-delete-bytes-rate", "remote-storage-manager-metrics", "Rate of deleted number of bytes estimated from segment size", new String[0]);
    final MetricNameTemplate segmentDeleteBytesRateByTopic = new MetricNameTemplate("segment-delete-bytes-rate", "remote-storage-manager-metrics", "Rate of deleted number of bytes estimated from segment size tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteBytesRateByTopicPartition = new MetricNameTemplate("segment-delete-bytes-rate", "remote-storage-manager-metrics", "Rate of deleted number of bytes estimated from segment size tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_BYTES_TOTAL = "segment-delete-bytes-total";
    final MetricNameTemplate segmentDeleteBytesTotal = new MetricNameTemplate("segment-delete-bytes-total", "remote-storage-manager-metrics", "Total number of deleted number of bytes estimated from segment size", new String[0]);
    final MetricNameTemplate segmentDeleteBytesTotalByTopic = new MetricNameTemplate("segment-delete-bytes-total", "remote-storage-manager-metrics", "Total number of deleted number of bytes estimated from segment size tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteBytesTotalByTopicPartition = new MetricNameTemplate("segment-delete-bytes-total", "remote-storage-manager-metrics", "Total number of deleted number of bytes estimated from segment size tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_TIME = "segment-delete-time";
    static final String SEGMENT_DELETE_TIME_DOC = "time spent deleting log segment and indexes";
    static final String SEGMENT_DELETE_TIME_AVG = "segment-delete-time-avg";
    final MetricNameTemplate segmentDeleteTimeAvg = new MetricNameTemplate("segment-delete-time-avg", "remote-storage-manager-metrics", "Average time spent deleting log segment and indexes", new String[0]);
    final MetricNameTemplate segmentDeleteTimeAvgByTopic = new MetricNameTemplate("segment-delete-time-avg", "remote-storage-manager-metrics", "Average time spent deleting log segment and indexes tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteTimeAvgByTopicPartition = new MetricNameTemplate("segment-delete-time-avg", "remote-storage-manager-metrics", "Average time spent deleting log segment and indexes tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_TIME_MAX = "segment-delete-time-max";
    final MetricNameTemplate segmentDeleteTimeMax = new MetricNameTemplate("segment-delete-time-max", "remote-storage-manager-metrics", "Maximum time spent deleting log segment and indexes", new String[0]);
    final MetricNameTemplate segmentDeleteTimeMaxByTopic = new MetricNameTemplate("segment-delete-time-max", "remote-storage-manager-metrics", "Maximum time spent deleting log segment and indexes tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteTimeMaxByTopicPartition = new MetricNameTemplate("segment-delete-time-max", "remote-storage-manager-metrics", "Maximum time spent deleting log segment and indexes tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_ERRORS = "segment-delete-errors";
    static final String SEGMENT_DELETE_ERRORS_DOC = "errors during remote log segment deletion";
    static final String SEGMENT_DELETE_ERRORS_RATE = "segment-delete-errors-rate";
    final MetricNameTemplate segmentDeleteErrorsRate = new MetricNameTemplate("segment-delete-errors-rate", "remote-storage-manager-metrics", "Rate of errors during remote log segment deletion", new String[0]);
    final MetricNameTemplate segmentDeleteErrorsRateByTopic = new MetricNameTemplate("segment-delete-errors-rate", "remote-storage-manager-metrics", "Rate of errors during remote log segment deletion tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteErrorsRateByTopicPartition = new MetricNameTemplate("segment-delete-errors-rate", "remote-storage-manager-metrics", "Rate of errors during remote log segment deletion tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_DELETE_ERRORS_TOTAL = "segment-delete-errors-total";
    final MetricNameTemplate segmentDeleteErrorsTotal = new MetricNameTemplate("segment-delete-errors-total", "remote-storage-manager-metrics", "Total number of errors during remote log segment deletion", new String[0]);
    final MetricNameTemplate segmentDeleteErrorsTotalByTopic = new MetricNameTemplate("segment-delete-errors-total", "remote-storage-manager-metrics", "Total number of errors during remote log segment deletion tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentDeleteErrorsTotalByTopicPartition = new MetricNameTemplate("segment-delete-errors-total", "remote-storage-manager-metrics", "Total number of errors during remote log segment deletion tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_FETCH = "segment-fetch";
    static final String SEGMENT_FETCH_REQUESTED_BYTES_DOC = "bytes requested by broker, not necessarily the amount to be consumed by fetcher";
    static final String SEGMENT_FETCH_REQUESTED_BYTES = "segment-fetch-requested-bytes";
    static final String SEGMENT_FETCH_REQUESTED_BYTES_RATE = "segment-fetch-requested-bytes-rate";
    final MetricNameTemplate segmentFetchRequestedBytesRate = new MetricNameTemplate("segment-fetch-requested-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes requested by broker, not necessarily the amount to be consumed by fetcher", new String[0]);
    final MetricNameTemplate segmentFetchRequestedBytesRateByTopic = new MetricNameTemplate("segment-fetch-requested-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes requested by broker, not necessarily the amount to be consumed by fetcher tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentFetchRequestedBytesRateByTopicPartition = new MetricNameTemplate("segment-fetch-requested-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes requested by broker, not necessarily the amount to be consumed by fetcher tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String SEGMENT_FETCH_REQUESTED_BYTES_TOTAL = "segment-fetch-requested-bytes-total";
    final MetricNameTemplate segmentFetchRequestedBytesTotal = new MetricNameTemplate("segment-fetch-requested-bytes-total", "remote-storage-manager-metrics", "Total number of bytes requested by broker, not necessarily the amount to be consumed by fetcher", new String[0]);
    final MetricNameTemplate segmentFetchRequestedBytesTotalByTopic = new MetricNameTemplate("segment-fetch-requested-bytes-total", "remote-storage-manager-metrics", "Total number of bytes requested by broker, not necessarily the amount to be consumed by fetcher tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate segmentFetchRequestedBytesTotalByTopicPartition = new MetricNameTemplate("segment-fetch-requested-bytes-total", "remote-storage-manager-metrics", "Total number of bytes requested by broker, not necessarily the amount to be consumed by fetcher tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    static final String OBJECT_UPLOAD = "object-upload";
    static final String OBJECT_UPLOAD_DOC = "upload to a storage backend operations";
    static final String OBJECT_UPLOAD_RATE = "object-upload-rate";
    final MetricNameTemplate objectUploadRequestsRate = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations", new String[0]);
    final MetricNameTemplate objectUploadRequestsRateByTopic = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsRateByTopicPartition = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsRateByObjectType = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by object type", OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsRateByTopicAndObjectType = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by topic and object type", TOPIC_OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsRateByTopicPartitionAndObjectType = new MetricNameTemplate("object-upload-rate", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by topic, partition and object type", TOPIC_PARTITION_OBJECT_TYPE_TAG_NAMES);
    static final String OBJECT_UPLOAD_TOTAL = "object-upload-total";
    final MetricNameTemplate objectUploadRequestsTotal = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Total number of upload to a storage backend operations", new String[0]);
    final MetricNameTemplate objectUploadRequestsTotalByTopic = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Total number of upload to a storage backend operations tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsTotalByTopicPartition = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Total number of upload to a storage backend operations tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsTotalByObjectType = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Total number of upload to a storage backend operations tagged by object type", OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsTotalByTopicAndObjectType = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Total number of upload to a storage backend operations tagged by topic and object type", TOPIC_OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadRequestsTotalByTopicPartitionAndObjectType = new MetricNameTemplate("object-upload-total", "remote-storage-manager-metrics", "Rate of upload to a storage backend operations tagged by topic, partition and object type", TOPIC_PARTITION_OBJECT_TYPE_TAG_NAMES);
    static final String OBJECT_UPLOAD_BYTES = "object-upload-bytes";
    static final String OBJECT_UPLOAD_BYTES_DOC = "bytes uploaded to a storage backend";
    static final String OBJECT_UPLOAD_BYTES_RATE = "object-upload-bytes-rate";
    final MetricNameTemplate objectUploadBytesRate = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend", new String[0]);
    final MetricNameTemplate objectUploadBytesRateByTopic = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesRateByTopicPartition = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesRateByObjectType = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend tagged by object type", OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesRateByTopicAndObjectType = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend tagged by topic and object type", TOPIC_OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesRateByTopicPartitionAndObjectType = new MetricNameTemplate("object-upload-bytes-rate", "remote-storage-manager-metrics", "Rate of bytes uploaded to a storage backend tagged by topic, partition and object type", TOPIC_PARTITION_OBJECT_TYPE_TAG_NAMES);
    public static final String OBJECT_UPLOAD_BYTES_TOTAL = "object-upload-bytes-total";
    final MetricNameTemplate objectUploadBytesTotal = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend", new String[0]);
    final MetricNameTemplate objectUploadBytesTotalByTopic = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend tagged by topic", TOPIC_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesTotalByTopicPartition = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend tagged by topic and partition", TOPIC_PARTITION_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesTotalByObjectType = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend tagged by object type", OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesTotalByTopicAndObjectType = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend tagged by topic and object type", TOPIC_OBJECT_TYPE_TAG_NAMES);
    final MetricNameTemplate objectUploadBytesTotalByTopicPartitionAndObjectType = new MetricNameTemplate("object-upload-bytes-total", "remote-storage-manager-metrics", "Total number of bytes uploaded to a storage backend tagged by topic, partition and object type", TOPIC_PARTITION_OBJECT_TYPE_TAG_NAMES);

    public static String sensorName(String name) {
        return name;
    }

    public static String sensorNameByObjectType(ObjectKeyFactory.Suffix suffix, String name) {
        return "object-type." + suffix.value + "." + name;
    }

    public static String sensorNameByTopic(TopicPartition topicPartition, String name) {
        return "topic." + topicPartition.topic() + "." + name;
    }

    public static String sensorNameByTopicAndObjectType(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix, String name) {
        return "topic." + topicPartition.topic() + ".object-type." + suffix.value + "." + name;
    }

    public static String sensorNameByTopicPartition(TopicPartition topicPartition, String name) {
        return "topic." + topicPartition.topic() + ".partition." + topicPartition.partition() + "." + name;
    }

    public static String sensorNameByTopicPartitionAndObjectType(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix, String name) {
        return "topic." + topicPartition.topic() + ".partition." + topicPartition.partition() + ".object-type." + suffix.value + "." + name;
    }

    static Map<String, String> topicTags(TopicPartition topicPartition) {
        return Map.of(TAG_NAME_TOPIC, topicPartition.topic());
    }

    static Map<String, String> topicAndObjectTypeTags(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix) {
        return Map.of(TAG_NAME_TOPIC, topicPartition.topic(), TAG_NAME_OBJECT_TYPE, suffix.value);
    }

    static Map<String, String> topicPartitionTags(TopicPartition topicPartition) {
        return Map.of(TAG_NAME_TOPIC, topicPartition.topic(), TAG_NAME_PARTITION, String.valueOf(topicPartition.partition()));
    }

    static Map<String, String> topicPartitionAndObjectTypeTags(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix) {
        return Map.of(TAG_NAME_TOPIC, topicPartition.topic(), TAG_NAME_PARTITION, String.valueOf(topicPartition.partition()), TAG_NAME_OBJECT_TYPE, suffix.value);
    }

    static Map<String, String> objectTypeTags(ObjectKeyFactory.Suffix suffix) {
        return Map.of(TAG_NAME_OBJECT_TYPE, suffix.value);
    }

    public Iterable<MetricNameTemplate> all() {
        return List.of(this.segmentCopyTimeAvg, this.segmentCopyTimeAvgByTopic, this.segmentCopyTimeAvgByTopicPartition, this.segmentCopyTimeMax, this.segmentCopyTimeMaxByTopic, this.segmentCopyTimeMaxByTopicPartition, this.segmentDeleteRequestsRate, this.segmentDeleteRequestsRateByTopic, this.segmentDeleteRequestsRateByTopicPartition, this.segmentDeleteRequestsTotal, this.segmentDeleteRequestsTotalByTopic, this.segmentDeleteRequestsTotalByTopicPartition, this.segmentDeleteBytesTotal, this.segmentDeleteBytesTotalByTopic, this.segmentDeleteBytesTotalByTopicPartition, this.segmentDeleteTimeAvg, this.segmentDeleteTimeAvgByTopic, this.segmentDeleteTimeAvgByTopicPartition, this.segmentDeleteTimeMax, this.segmentDeleteTimeMaxByTopic, this.segmentDeleteTimeMaxByTopicPartition, this.segmentDeleteErrorsRate, this.segmentDeleteErrorsRateByTopic, this.segmentDeleteErrorsRateByTopicPartition, this.segmentDeleteErrorsTotal, this.segmentDeleteErrorsTotalByTopic, this.segmentDeleteErrorsTotalByTopicPartition, this.segmentFetchRequestedBytesRate, this.segmentFetchRequestedBytesRateByTopic, this.segmentFetchRequestedBytesRateByTopicPartition, this.segmentFetchRequestedBytesTotal, this.segmentFetchRequestedBytesTotalByTopic, this.segmentFetchRequestedBytesTotalByTopicPartition, this.objectUploadRequestsRate, this.objectUploadRequestsRateByTopic, this.objectUploadRequestsRateByTopicPartition, this.objectUploadRequestsRateByObjectType, this.objectUploadRequestsRateByTopicAndObjectType, this.objectUploadRequestsRateByTopicPartitionAndObjectType, this.objectUploadRequestsTotal, this.objectUploadRequestsTotalByTopic, this.objectUploadRequestsTotalByTopicPartition, this.objectUploadRequestsTotalByObjectType, this.objectUploadRequestsTotalByTopicAndObjectType, this.objectUploadRequestsTotalByTopicPartitionAndObjectType, this.objectUploadBytesRate, this.objectUploadBytesRateByTopic, this.objectUploadBytesRateByTopicPartition, this.objectUploadBytesRateByObjectType, this.objectUploadBytesRateByTopicAndObjectType, this.objectUploadBytesRateByTopicPartitionAndObjectType, this.objectUploadBytesTotal, this.objectUploadBytesTotalByTopic, this.objectUploadBytesTotalByTopicPartition, this.objectUploadBytesTotalByObjectType, this.objectUploadBytesTotalByTopicAndObjectType, this.objectUploadBytesTotalByTopicPartitionAndObjectType);
    }
}

