/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import io.aiven.kafka.tieredstorage.ObjectKeyFactory;
import io.aiven.kafka.tieredstorage.metrics.MetricsRegistry;
import io.aiven.kafka.tieredstorage.metrics.SensorProvider;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private final org.apache.kafka.common.metrics.Metrics metrics;
    private final MetricsRegistry metricsRegistry;

    public Metrics(Time time, MetricConfig metricConfig) {
        JmxReporter reporter = new JmxReporter();
        this.metrics = new org.apache.kafka.common.metrics.Metrics(metricConfig, List.of(reporter), time, new KafkaMetricsContext("aiven.kafka.server.tieredstorage"));
        this.metricsRegistry = new MetricsRegistry();
    }

    public void recordSegmentCopyTime(TopicPartition topicPartition, long startMs, long endMs) {
        long time = endMs - startMs;
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-copy-time")).with(this.metricsRegistry.segmentCopyTimeAvg, new Avg()).with(this.metricsRegistry.segmentCopyTimeMax, new Max()).get().record(time);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-copy-time"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentCopyTimeAvgByTopic, new Avg()).with(this.metricsRegistry.segmentCopyTimeMaxByTopic, new Max()).get().record(time);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-copy-time"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentCopyTimeAvgByTopicPartition, new Avg()).with(this.metricsRegistry.segmentCopyTimeMaxByTopicPartition, new Max()).get().record(time);
    }

    public void recordSegmentDelete(TopicPartition topicPartition, long bytes) {
        this.recordSegmentDeleteRequests(topicPartition);
        this.recordSegmentDeleteBytes(topicPartition, bytes);
    }

    private void recordSegmentDeleteBytes(TopicPartition topicPartition, long bytes) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-delete-bytes")).with(this.metricsRegistry.segmentDeleteBytesRate, new Rate()).with(this.metricsRegistry.segmentDeleteBytesTotal, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-delete-bytes"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentDeleteBytesRateByTopic, new Rate()).with(this.metricsRegistry.segmentDeleteBytesTotalByTopic, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-delete-bytes"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentDeleteBytesRateByTopicPartition, new Rate()).with(this.metricsRegistry.segmentDeleteBytesTotalByTopicPartition, new CumulativeSum()).get().record(bytes);
    }

    private void recordSegmentDeleteRequests(TopicPartition topicPartition) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-delete")).with(this.metricsRegistry.segmentDeleteRequestsRate, new Rate()).with(this.metricsRegistry.segmentDeleteRequestsTotal, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-delete"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentDeleteRequestsRateByTopic, new Rate()).with(this.metricsRegistry.segmentDeleteRequestsTotalByTopic, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-delete"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentDeleteRequestsRateByTopicPartition, new Rate()).with(this.metricsRegistry.segmentDeleteRequestsTotalByTopicPartition, new CumulativeCount()).get().record();
    }

    public void recordSegmentDeleteTime(TopicPartition topicPartition, long startMs, long endMs) {
        long time = endMs - startMs;
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-delete-time")).with(this.metricsRegistry.segmentDeleteTimeAvg, new Avg()).with(this.metricsRegistry.segmentDeleteTimeMax, new Max()).get().record(time);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-delete-time"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentDeleteTimeAvgByTopic, new Avg()).with(this.metricsRegistry.segmentDeleteTimeMaxByTopic, new Max()).get().record(time);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-delete-time"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentDeleteTimeAvgByTopicPartition, new Avg()).with(this.metricsRegistry.segmentDeleteTimeMaxByTopicPartition, new Max()).get().record(time);
    }

    public void recordSegmentDeleteError(TopicPartition topicPartition) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-delete-errors")).with(this.metricsRegistry.segmentDeleteErrorsRate, new Rate()).with(this.metricsRegistry.segmentDeleteErrorsTotal, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-delete-errors"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentDeleteErrorsRateByTopic, new Rate()).with(this.metricsRegistry.segmentDeleteErrorsTotalByTopic, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-delete-errors"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentDeleteErrorsRateByTopicPartition, new Rate()).with(this.metricsRegistry.segmentDeleteErrorsTotalByTopicPartition, new CumulativeCount()).get().record();
    }

    public void recordSegmentFetch(TopicPartition topicPartition, long bytes) {
        this.recordSegmentFetchRequestedBytes(topicPartition, bytes);
    }

    private void recordSegmentFetchRequestedBytes(TopicPartition topicPartition, long bytes) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("segment-fetch-requested-bytes")).with(this.metricsRegistry.segmentFetchRequestedBytesRate, new Rate()).with(this.metricsRegistry.segmentFetchRequestedBytesTotal, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "segment-fetch-requested-bytes"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.segmentFetchRequestedBytesRateByTopic, new Rate()).with(this.metricsRegistry.segmentFetchRequestedBytesTotalByTopic, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "segment-fetch-requested-bytes"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.segmentFetchRequestedBytesRateByTopicPartition, new Rate()).with(this.metricsRegistry.segmentFetchRequestedBytesTotalByTopicPartition, new CumulativeSum()).get().record(bytes);
    }

    public void recordObjectUpload(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix, long bytes) {
        this.recordObjectUploadRequests(topicPartition, suffix);
        this.recordObjectUploadBytes(topicPartition, suffix, bytes);
    }

    private void recordObjectUploadBytes(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix, long bytes) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("object-upload-bytes")).with(this.metricsRegistry.objectUploadBytesRate, new Rate()).with(this.metricsRegistry.objectUploadBytesTotal, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "object-upload-bytes"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.objectUploadBytesRateByTopic, new Rate()).with(this.metricsRegistry.objectUploadBytesTotalByTopic, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "object-upload-bytes"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadBytesRateByTopicPartition, new Rate()).with(this.metricsRegistry.objectUploadBytesTotalByTopicPartition, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByObjectType(suffix, "object-upload-bytes"), () -> MetricsRegistry.objectTypeTags(suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadBytesRateByObjectType, new Rate()).with(this.metricsRegistry.objectUploadBytesTotalByObjectType, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicAndObjectType(topicPartition, suffix, "object-upload-bytes"), () -> MetricsRegistry.topicAndObjectTypeTags(topicPartition, suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadBytesRateByTopicAndObjectType, new Rate()).with(this.metricsRegistry.objectUploadBytesTotalByTopicAndObjectType, new CumulativeSum()).get().record(bytes);
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartitionAndObjectType(topicPartition, suffix, "object-upload-bytes"), () -> MetricsRegistry.topicPartitionAndObjectTypeTags(topicPartition, suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadBytesRateByTopicPartitionAndObjectType, new Rate()).with(this.metricsRegistry.objectUploadBytesTotalByTopicPartitionAndObjectType, new CumulativeSum()).get().record(bytes);
    }

    private void recordObjectUploadRequests(TopicPartition topicPartition, ObjectKeyFactory.Suffix suffix) {
        new SensorProvider(this.metrics, MetricsRegistry.sensorName("object-upload")).with(this.metricsRegistry.objectUploadRequestsRate, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotal, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopic(topicPartition, "object-upload"), () -> MetricsRegistry.topicTags(topicPartition)).with(this.metricsRegistry.objectUploadRequestsRateByTopic, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotalByTopic, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartition(topicPartition, "object-upload"), () -> MetricsRegistry.topicPartitionTags(topicPartition), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadRequestsRateByTopicPartition, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotalByTopicPartition, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByObjectType(suffix, "object-upload"), () -> MetricsRegistry.objectTypeTags(suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadRequestsRateByObjectType, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotalByObjectType, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicAndObjectType(topicPartition, suffix, "object-upload"), () -> MetricsRegistry.topicAndObjectTypeTags(topicPartition, suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadRequestsRateByTopicAndObjectType, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotalByTopicAndObjectType, new CumulativeCount()).get().record();
        new SensorProvider(this.metrics, MetricsRegistry.sensorNameByTopicPartitionAndObjectType(topicPartition, suffix, "object-upload"), () -> MetricsRegistry.topicPartitionAndObjectTypeTags(topicPartition, suffix), Sensor.RecordingLevel.DEBUG).with(this.metricsRegistry.objectUploadRequestsRateByTopicPartitionAndObjectType, new Rate()).with(this.metricsRegistry.objectUploadRequestsTotalByTopicPartitionAndObjectType, new CumulativeCount()).get().record();
    }

    public void close() {
        try {
            this.metrics.close();
        }
        catch (Exception e) {
            log.warn("Error while closing metrics", e);
        }
    }
}

