/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.aiven.kafka.tieredstorage.metrics.CaffeineMetricsRegistry;
import io.aiven.kafka.tieredstorage.metrics.MeasurableValue;
import io.aiven.kafka.tieredstorage.metrics.SensorProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class CaffeineStatsCounter
implements StatsCounter {
    private final Metrics metrics;
    private final LongAdder cacheHitCount = new LongAdder();
    private final LongAdder cacheMissCount = new LongAdder();
    private final LongAdder cacheLoadSuccessCount = new LongAdder();
    private final LongAdder cacheLoadSuccessTimeTotal = new LongAdder();
    private final LongAdder cacheLoadFailureCount = new LongAdder();
    private final LongAdder cacheLoadFailureTimeTotal = new LongAdder();
    private final LongAdder cacheEvictionCountTotal = new LongAdder();
    private final LongAdder cacheEvictionWeightTotal = new LongAdder();
    private final ConcurrentHashMap<RemovalCause, LongAdder> cacheEvictionCountByCause = new ConcurrentHashMap();
    private final ConcurrentHashMap<RemovalCause, LongAdder> cacheEvictionWeightByCause;
    private final CaffeineMetricsRegistry metricsRegistry;

    public CaffeineStatsCounter(String groupName) {
        Arrays.stream(RemovalCause.values()).forEach(cause -> this.cacheEvictionCountByCause.put((RemovalCause)((Object)cause), new LongAdder()));
        this.cacheEvictionWeightByCause = new ConcurrentHashMap();
        Arrays.stream(RemovalCause.values()).forEach(cause -> this.cacheEvictionWeightByCause.put((RemovalCause)((Object)cause), new LongAdder()));
        JmxReporter reporter = new JmxReporter();
        this.metrics = new Metrics(new MetricConfig(), List.of(reporter), Time.SYSTEM, new KafkaMetricsContext("aiven.kafka.server.tieredstorage.cache"));
        this.metricsRegistry = new CaffeineMetricsRegistry(groupName);
        this.initSensor(this.metricsRegistry.cacheHitsMetricName, "cache-hits", this.cacheHitCount);
        this.initSensor(this.metricsRegistry.cacheMissesMetricName, "cache-misses", this.cacheMissCount);
        this.initSensor(this.metricsRegistry.cacheLoadSuccessMetricName, "cache-load-success", this.cacheLoadSuccessCount);
        this.initSensor(this.metricsRegistry.cacheLoadSuccessTimeMetricName, "cache-load-success-time", this.cacheLoadSuccessTimeTotal);
        this.initSensor(this.metricsRegistry.cacheLoadFailureMetricName, "cache-load-failure", this.cacheLoadFailureCount);
        this.initSensor(this.metricsRegistry.cacheLoadFailureTimeMetricName, "cache-load-failure-time", this.cacheLoadFailureTimeTotal);
        this.initSensor(this.metricsRegistry.cacheEvictionMetricName, "cache-eviction", this.cacheEvictionCountTotal);
        Arrays.stream(RemovalCause.values()).forEach(cause -> this.initSensor(this.metricsRegistry.cacheEvictionByCauseMetricName, "cause." + cause.name() + ".cache-eviction", this.cacheEvictionCountByCause.get(cause), () -> Map.of("cause", cause.name())));
        this.initSensor(this.metricsRegistry.cacheEvictionWeightMetricName, "cache-eviction-weight", this.cacheEvictionWeightTotal);
        Arrays.stream(RemovalCause.values()).forEach(cause -> this.initSensor(this.metricsRegistry.cacheEvictionWeightByCauseMetricName, "cause." + cause.name() + ".cache-eviction", this.cacheEvictionWeightByCause.get(cause), () -> Map.of("cause", cause.name())));
    }

    private void initSensor(MetricNameTemplate metricNameTemplate, String sensorName, LongAdder value, Supplier<Map<String, String>> tagsSupplier) {
        new SensorProvider(this.metrics, sensorName, tagsSupplier).with(metricNameTemplate, new MeasurableValue(value::sum)).get();
    }

    private void initSensor(MetricNameTemplate metricNameTemplate, String sensorName, LongAdder value) {
        this.initSensor(metricNameTemplate, sensorName, value, Collections::emptyMap);
    }

    @Override
    public void recordHits(int count) {
        this.cacheHitCount.add(count);
    }

    @Override
    public void recordMisses(int count) {
        this.cacheMissCount.add(count);
    }

    @Override
    public void recordLoadSuccess(long loadTime) {
        this.cacheLoadSuccessCount.increment();
        this.cacheLoadSuccessTimeTotal.add(loadTime);
    }

    @Override
    public void recordLoadFailure(long loadTime) {
        this.cacheLoadFailureCount.increment();
        this.cacheLoadFailureTimeTotal.add(loadTime);
    }

    @Override
    public void recordEviction(int weight, RemovalCause cause) {
        this.cacheEvictionCountTotal.increment();
        this.cacheEvictionCountByCause.get((Object)cause).increment();
        this.cacheEvictionWeightTotal.add(weight);
        this.cacheEvictionWeightByCause.get((Object)cause).add(weight);
    }

    public void recordMiss() {
        this.cacheMissCount.increment();
    }

    public void recordHit() {
        this.cacheHitCount.increment();
    }

    public void registerSizeMetric(Supplier<Long> sizeSupplier) {
        new SensorProvider(this.metrics, "cache-size").with(this.metricsRegistry.cacheSizeTotalMetricName, new MeasurableValue(sizeSupplier)).get();
    }

    @Override
    public CacheStats snapshot() {
        return CacheStats.of(CaffeineStatsCounter.negativeToMaxValue(this.cacheHitCount.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheMissCount.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheLoadSuccessCount.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheLoadFailureCount.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheLoadSuccessTimeTotal.sum() + this.cacheLoadFailureTimeTotal.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheEvictionCountTotal.sum()), CaffeineStatsCounter.negativeToMaxValue(this.cacheEvictionWeightTotal.sum()));
    }

    public String toString() {
        return this.snapshot().toString();
    }

    private static long negativeToMaxValue(long value) {
        return value >= 0L ? value : Long.MAX_VALUE;
    }
}

