/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metrics;

import java.util.List;
import org.apache.kafka.common.MetricNameTemplate;

public class CaffeineMetricsRegistry {
    public static final String METRIC_CONTEXT = "aiven.kafka.server.tieredstorage.cache";
    static final String CACHE_HITS = "cache-hits";
    static final String CACHE_HITS_TOTAL = "cache-hits-total";
    static final String CACHE_MISSES = "cache-misses";
    static final String CACHE_MISSES_TOTAL = "cache-misses-total";
    static final String CACHE_LOAD = "cache-load";
    static final String CACHE_LOAD_SUCCESS = "cache-load-success";
    static final String CACHE_LOAD_SUCCESS_TOTAL = "cache-load-success-total";
    static final String CACHE_LOAD_SUCCESS_TIME = "cache-load-success-time";
    static final String CACHE_LOAD_SUCCESS_TIME_TOTAL = "cache-load-success-time-total";
    static final String CACHE_LOAD_FAILURE = "cache-load-failure";
    static final String CACHE_LOAD_FAILURE_TOTAL = "cache-load-failure-total";
    static final String CACHE_LOAD_FAILURE_TIME = "cache-load-failure-time";
    static final String CACHE_LOAD_FAILURE_TIME_TOTAL = "cache-load-failure-time-total";
    static final String CACHE_EVICTION = "cache-eviction";
    static final String CACHE_EVICTION_TOTAL = "cache-eviction-total";
    static final String CACHE_EVICTION_WEIGHT = "cache-eviction-weight";
    static final String CACHE_EVICTION_WEIGHT_TOTAL = "cache-eviction-weight-total";
    static final String CACHE_SIZE = "cache-size";
    static final String CACHE_SIZE_TOTAL = "cache-size-total";
    final String groupName;
    final MetricNameTemplate cacheHitsMetricName;
    final MetricNameTemplate cacheMissesMetricName;
    final MetricNameTemplate cacheLoadSuccessMetricName;
    final MetricNameTemplate cacheLoadSuccessTimeMetricName;
    final MetricNameTemplate cacheLoadFailureMetricName;
    final MetricNameTemplate cacheLoadFailureTimeMetricName;
    final MetricNameTemplate cacheEvictionMetricName;
    final MetricNameTemplate cacheEvictionByCauseMetricName;
    final MetricNameTemplate cacheEvictionWeightMetricName;
    final MetricNameTemplate cacheEvictionWeightByCauseMetricName;
    final MetricNameTemplate cacheSizeTotalMetricName;

    public CaffeineMetricsRegistry(String groupName) {
        this.groupName = groupName;
        this.cacheHitsMetricName = new MetricNameTemplate(CACHE_HITS_TOTAL, groupName, "Cache hits", new String[0]);
        this.cacheMissesMetricName = new MetricNameTemplate(CACHE_MISSES_TOTAL, groupName, "Cache misses", new String[0]);
        this.cacheLoadSuccessMetricName = new MetricNameTemplate(CACHE_LOAD_SUCCESS_TOTAL, groupName, "Successful load of a new entry", new String[0]);
        this.cacheLoadSuccessTimeMetricName = new MetricNameTemplate(CACHE_LOAD_SUCCESS_TIME_TOTAL, groupName, "Time to load a new entry", new String[0]);
        this.cacheLoadFailureMetricName = new MetricNameTemplate(CACHE_LOAD_FAILURE_TOTAL, groupName, "Failures to load a new entry", new String[0]);
        this.cacheLoadFailureTimeMetricName = new MetricNameTemplate(CACHE_LOAD_FAILURE_TIME_TOTAL, groupName, "Time when failing to load a new entry", new String[0]);
        this.cacheEvictionMetricName = new MetricNameTemplate(CACHE_EVICTION_TOTAL, groupName, "Eviction of an entry from the cache", new String[0]);
        this.cacheEvictionByCauseMetricName = new MetricNameTemplate(CACHE_EVICTION_TOTAL, groupName, "Eviction of an entry from the cache tagged by cause", "cause");
        this.cacheEvictionWeightMetricName = new MetricNameTemplate(CACHE_EVICTION_WEIGHT_TOTAL, groupName, "Weight of evicted entry", new String[0]);
        this.cacheEvictionWeightByCauseMetricName = new MetricNameTemplate(CACHE_EVICTION_WEIGHT_TOTAL, groupName, "Weight of evicted entry tagged by cause", "cause");
        this.cacheSizeTotalMetricName = new MetricNameTemplate(CACHE_SIZE_TOTAL, groupName, "Estimated number of entries in the cache", new String[0]);
    }

    public List<MetricNameTemplate> all() {
        return List.of(this.cacheHitsMetricName, this.cacheMissesMetricName, this.cacheLoadSuccessMetricName, this.cacheLoadSuccessTimeMetricName, this.cacheLoadFailureMetricName, this.cacheLoadFailureTimeMetricName, this.cacheEvictionMetricName, this.cacheEvictionByCauseMetricName, this.cacheEvictionWeightMetricName, this.cacheEvictionWeightByCauseMetricName, this.cacheSizeTotalMetricName);
    }
}

