/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metadata;

import io.aiven.kafka.tieredstorage.ObjectKeyFactory;
import io.aiven.kafka.tieredstorage.metadata.SegmentCustomMetadataBuilder;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;

public enum SegmentCustomMetadataField {
    REMOTE_SIZE(0, new Field("remote_size", Type.VARLONG), SegmentCustomMetadataBuilder::totalSize),
    OBJECT_PREFIX(1, new Field("object_prefix", Type.COMPACT_STRING), b -> b.objectKeyFactory.prefix()),
    OBJECT_KEY(2, new Field("object_key", Type.COMPACT_STRING), b -> ObjectKeyFactory.mainPath(b.segmentMetadata));

    static final Field.TaggedFieldsSection FIELDS_SECTION;
    public static final Schema CUSTOM_METADATA_SCHEMA;
    public static final String TAGGED_FIELD_NAME;
    final int index;
    final Field field;
    final Function<SegmentCustomMetadataBuilder, Object> valueProvider;

    private SegmentCustomMetadataField(int index, Field field, Function<SegmentCustomMetadataBuilder, Object> valueProvider) {
        this.index = index;
        this.field = field;
        this.valueProvider = valueProvider;
    }

    public static String[] names() {
        return (String[])Arrays.stream(SegmentCustomMetadataField.values()).map(Enum::name).toArray(String[]::new);
    }

    public int index() {
        return this.index;
    }

    static {
        FIELDS_SECTION = Field.TaggedFieldsSection.of(SegmentCustomMetadataField.REMOTE_SIZE.index, SegmentCustomMetadataField.REMOTE_SIZE.field, SegmentCustomMetadataField.OBJECT_PREFIX.index, SegmentCustomMetadataField.OBJECT_PREFIX.field, SegmentCustomMetadataField.OBJECT_KEY.index, SegmentCustomMetadataField.OBJECT_KEY.field);
        CUSTOM_METADATA_SCHEMA = new Schema(FIELDS_SECTION);
        TAGGED_FIELD_NAME = SegmentCustomMetadataField.FIELDS_SECTION.name;
    }
}

