/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.metadata;

import io.aiven.kafka.tieredstorage.ObjectKeyFactory;
import io.aiven.kafka.tieredstorage.metadata.SegmentCustomMetadataField;
import java.util.EnumMap;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;

public class SegmentCustomMetadataBuilder {
    final ObjectKeyFactory objectKeyFactory;
    final RemoteLogSegmentMetadata segmentMetadata;
    final EnumMap<ObjectKeyFactory.Suffix, Long> uploadResults;
    final Set<SegmentCustomMetadataField> fields;

    public SegmentCustomMetadataBuilder(Set<SegmentCustomMetadataField> fields, ObjectKeyFactory objectKeyFactory, RemoteLogSegmentMetadata segmentMetadata) {
        this.fields = fields;
        this.objectKeyFactory = objectKeyFactory;
        this.segmentMetadata = segmentMetadata;
        this.uploadResults = new EnumMap(ObjectKeyFactory.Suffix.class);
    }

    public SegmentCustomMetadataBuilder addUploadResult(ObjectKeyFactory.Suffix suffix, long bytes) {
        if (this.uploadResults.containsKey((Object)suffix)) {
            throw new IllegalArgumentException("Upload results for suffix " + String.valueOf((Object)suffix) + " already added");
        }
        this.uploadResults.put(suffix, bytes);
        return this;
    }

    public long totalSize() {
        return this.uploadResults.values().stream().mapToLong(value -> value).sum();
    }

    public NavigableMap<Integer, Object> build() {
        TreeMap<Integer, Object> taggedFields = new TreeMap<Integer, Object>();
        this.fields.forEach(field -> taggedFields.put(field.index(), field.valueProvider.apply(this)));
        return taggedFields;
    }
}

