/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.serde;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;

public class KafkaTypeSerdeModule {
    public static Module create() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Uuid.class, new UuidSerializer());
        module.setMixInAnnotation(TopicPartition.class, TopicPartitionSerdeMixin.class);
        module.setMixInAnnotation(TopicIdPartition.class, TopicIdPartitionSerdeMixin.class);
        module.setMixInAnnotation(RemoteLogSegmentId.class, RemoteLogSegmentIdMixin.class);
        module.setMixInAnnotation(RemoteLogSegmentMetadata.class, RemoteLogSegmentMetadataMixin.class);
        return module;
    }

    private static class UuidSerializer
    extends StdSerializer<Uuid> {
        UuidSerializer() {
            super(Uuid.class);
        }

        @Override
        public void serialize(Uuid value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    @JsonPropertyOrder(value={"topic", "partition"})
    private static abstract class TopicPartitionSerdeMixin {
        private TopicPartitionSerdeMixin() {
        }

        @JsonProperty(value="topic")
        public abstract String topic();

        @JsonProperty(value="partition")
        public abstract int partition();
    }

    @JsonPropertyOrder(value={"topicId", "topicPartition"})
    private static abstract class TopicIdPartitionSerdeMixin {
        private TopicIdPartitionSerdeMixin() {
        }

        @JsonProperty(value="topicId")
        public abstract Uuid topicId();

        @JsonProperty(value="topicPartition")
        public abstract TopicPartition topicPartition();
    }

    @JsonPropertyOrder(value={"topicIdPartition", "id"})
    private static abstract class RemoteLogSegmentIdMixin {
        private RemoteLogSegmentIdMixin() {
        }

        @JsonProperty(value="topicIdPartition")
        abstract TopicIdPartition topicIdPartition();

        @JsonProperty(value="id")
        abstract Uuid id();
    }

    @JsonPropertyOrder(value={"remoteLogSegmentId", "startOffset", "endOffset", "maxTimestampMs", "brokerId", "eventTimestampMs", "segmentLeaderEpochs"})
    private static abstract class RemoteLogSegmentMetadataMixin {
        private RemoteLogSegmentMetadataMixin() {
        }

        @JsonProperty(value="remoteLogSegmentId")
        public abstract RemoteLogSegmentId remoteLogSegmentId();

        @JsonProperty(value="startOffset")
        public abstract long startOffset();

        @JsonProperty(value="endOffset")
        public abstract long endOffset();

        @JsonProperty(value="maxTimestampMs")
        public abstract long maxTimestampMs();

        @JsonProperty(value="brokerId")
        public abstract int brokerId();

        @JsonProperty(value="eventTimestampMs")
        public abstract long eventTimestampMs();

        @JsonProperty(value="segmentLeaderEpochs")
        public abstract Map<Integer, Long> segmentLeaderEpochs();
    }
}

