/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.aiven.kafka.tieredstorage.security.EncryptedDataKey;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.SecretKey;

class DataKeySerializer
extends StdSerializer<SecretKey> {
    private final Function<byte[], EncryptedDataKey> dataKeyEncryptor;

    DataKeySerializer(Function<byte[], EncryptedDataKey> dataKeyEncryptor) {
        super(SecretKey.class);
        this.dataKeyEncryptor = Objects.requireNonNull(dataKeyEncryptor, "dataKeyEncryptor cannot be null");
    }

    @Override
    public void serialize(SecretKey value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        EncryptedDataKey encryptionResult = this.dataKeyEncryptor.apply(value.getEncoded());
        gen.writeString(encryptionResult.serialize());
    }
}

