/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.serde;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.aiven.kafka.tieredstorage.security.EncryptedDataKey;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class DataKeyDeserializer
extends StdDeserializer<SecretKey> {
    private final Function<EncryptedDataKey, byte[]> keyDecryptor;

    DataKeyDeserializer(Function<EncryptedDataKey, byte[]> keyDecryptor) {
        super(SecretKey.class);
        this.keyDecryptor = Objects.requireNonNull(keyDecryptor, "keyDecryptor cannot be null");
    }

    @Override
    public SecretKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        EncryptedDataKey encryptedDataKey;
        try {
            encryptedDataKey = EncryptedDataKey.parse(p.getText());
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException(p, "Error parsing encrypted data key string", (Throwable)e);
        }
        byte[] decryptedKey = this.keyDecryptor.apply(encryptedDataKey);
        return new SecretKeySpec(decryptedKey, "AES");
    }
}

