/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.github.luben.zstd.ZstdCompressCtx;
import io.aiven.kafka.tieredstorage.manifest.index.serde.ChunkSizesBinaryCodec;
import java.io.IOException;
import java.util.Base64;
import java.util.List;

public class TransformedChunksSerializer
extends JsonSerializer<List<Integer>> {
    @Override
    public void serialize(List<Integer> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        byte[] binEncoded = ChunkSizesBinaryCodec.encode(value);
        if (binEncoded.length > 0xA00000) {
            throw new IllegalArgumentException("Encoded index is too big (" + binEncoded.length + "), cannot serialize");
        }
        try (ZstdCompressCtx compressCtx = new ZstdCompressCtx();){
            try {
                compressCtx.setPledgedSrcSize(binEncoded.length);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            compressCtx.setContentSize(true);
            byte[] compressed = compressCtx.compress(binEncoded);
            String base64String = Base64.getEncoder().encodeToString(compressed);
            gen.writeString(base64String);
        }
    }
}

