/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.luben.zstd.Zstd;
import io.aiven.kafka.tieredstorage.manifest.index.serde.ChunkSizesBinaryCodec;
import java.io.IOException;
import java.util.Base64;
import java.util.List;

public class TransformedChunksDeserializer
extends JsonDeserializer<List<Integer>> {
    static final int MAX_DECOMPRESSED_SIZE = 0xA00000;

    @Override
    public List<Integer> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String base64String = p.getValueAsString();
        byte[] compressed = Base64.getDecoder().decode(base64String);
        long decompressedSize = Zstd.decompressedSize(compressed);
        if (decompressedSize < 0L || decompressedSize > 0xA00000L) {
            throw new IOException("Invalid decompressed size: " + decompressedSize);
        }
        byte[] binEncoded = new byte[(int)decompressedSize];
        Zstd.decompress(binEncoded, compressed);
        return ChunkSizesBinaryCodec.decode(binEncoded);
    }
}

