/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index.serde;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class ChunkSizesBinaryCodec {
    private static final int COUNT_SIZE = 4;
    private static final int BASE_SIZE = 4;
    private static final int BYTES_PER_VALUE_SIZE = 1;
    private static final int FULL_VALUE_SIZE = 4;

    ChunkSizesBinaryCodec() {
    }

    static byte[] encode(List<Integer> values) {
        int count = values.size();
        if (count == 0) {
            ByteBuffer intBuf = ByteBuffer.allocate(4);
            intBuf.putInt(count);
            return intBuf.array();
        }
        int lastValue = values.get(values.size() - 1);
        if (count == 1) {
            if (lastValue < 0) {
                throw new IllegalArgumentException("Values cannot be negative");
            }
            ByteBuffer intBuf = ByteBuffer.allocate(8);
            intBuf.putInt(count);
            intBuf.putInt(lastValue);
            return intBuf.array();
        }
        int min = values.stream().limit(values.size() - 1).mapToInt(Integer::intValue).min().getAsInt();
        if (min < 0 || lastValue < 0) {
            throw new IllegalArgumentException("Values cannot be negative");
        }
        int base = min;
        byte bytesPerValue = (byte)values.stream().limit(values.size() - 1).mapToInt(v -> ChunkSizesBinaryCodec.bytesNeeded(v - base)).max().getAsInt();
        int bufSize = 9 + (count - 1) * bytesPerValue + 4;
        ByteBuffer buf = ByteBuffer.allocate(bufSize);
        buf.putInt(count);
        buf.putInt(base);
        buf.put(bytesPerValue);
        ByteBuffer intBuf = ByteBuffer.allocate(4);
        int offset = 4 - bytesPerValue;
        for (int i = 0; i < values.size() - 1; ++i) {
            int value = values.get(i);
            int onBase = value - base;
            intBuf.rewind();
            intBuf.putInt(onBase);
            buf.put(intBuf.array(), offset, bytesPerValue);
        }
        buf.putInt(lastValue);
        return buf.array();
    }

    private static byte bytesNeeded(int v) {
        if (v <= 255) {
            return 1;
        }
        if (v <= 65535) {
            return 2;
        }
        if (v <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    static List<Integer> decode(byte[] array) {
        ByteBuffer buf = ByteBuffer.wrap(array);
        int count = buf.getInt();
        if (count == 0) {
            return List.of();
        }
        if (count == 1) {
            return List.of(Integer.valueOf(buf.getInt()));
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int base = buf.getInt();
        byte bytesPerValue = buf.get();
        ByteBuffer valBuf = ByteBuffer.allocate(4);
        int offset = 4 - bytesPerValue;
        for (int i = 0; i < count - 1; ++i) {
            buf.get(valBuf.array(), offset, bytesPerValue);
            valBuf.rewind();
            result.add(valBuf.getInt() + base);
        }
        result.add(buf.getInt());
        return result;
    }
}

