/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.manifest.index.AbstractChunkIndex;
import io.aiven.kafka.tieredstorage.manifest.index.serde.TransformedChunksDeserializer;
import io.aiven.kafka.tieredstorage.manifest.index.serde.TransformedChunksSerializer;
import java.util.List;
import java.util.Objects;

public class VariableSizeChunkIndex
extends AbstractChunkIndex {
    @JsonProperty(value="transformedChunks")
    @JsonSerialize(using=TransformedChunksSerializer.class)
    private final List<Integer> transformedChunks;
    private final List<Chunk> chunks;

    @JsonCreator
    public VariableSizeChunkIndex(@JsonProperty(value="originalChunkSize", required=true) int originalChunkSize, @JsonProperty(value="originalFileSize", required=true) int originalFileSize, @JsonProperty(value="transformedChunks", required=true) @JsonDeserialize(using=TransformedChunksDeserializer.class) List<Integer> transformedChunks) {
        super(originalChunkSize, originalFileSize, VariableSizeChunkIndex.finalTransformedChunkSize(Objects.requireNonNull(transformedChunks, "transformedChunks cannot be null")), transformedChunks.size());
        this.transformedChunks = transformedChunks;
        this.chunks = this.materializeChunks();
    }

    private static int finalTransformedChunkSize(List<Integer> transformedChunks) {
        return transformedChunks.get(transformedChunks.size() - 1);
    }

    @Override
    public List<Chunk> chunks() {
        return this.chunks;
    }

    @Override
    protected final int transformedChunkSize(int chunkI) {
        return this.transformedChunks.get(chunkI);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableSizeChunkIndex that = (VariableSizeChunkIndex)o;
        return this.originalChunkSize == that.originalChunkSize && this.originalFileSize == that.originalFileSize && Objects.equals(this.transformedChunks, that.transformedChunks);
    }

    public int hashCode() {
        return Objects.hash(this.originalChunkSize, this.originalFileSize, this.transformedChunks);
    }

    public String toString() {
        return "VariableSizeChunkIndex(originalChunkSize=" + this.originalChunkSize + ", originalFileSize=" + this.originalFileSize + ", transformedChunks=" + String.valueOf(this.transformedChunks) + ")";
    }
}

