/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index;

import io.aiven.kafka.tieredstorage.manifest.index.AbstractChunkIndexBuilder;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import io.aiven.kafka.tieredstorage.manifest.index.FixedSizeChunkIndex;

public class FixedSizeChunkIndexBuilder
extends AbstractChunkIndexBuilder {
    private final int transformedChunkSize;

    public FixedSizeChunkIndexBuilder(int originalChunkSize, int originalFileSize, int transformedChunkSize) {
        super(originalChunkSize, originalFileSize);
        this.checkSize(transformedChunkSize, "Transformed chunk size");
        this.transformedChunkSize = transformedChunkSize;
    }

    @Override
    protected void addChunk0(int transformedChunkSize) {
        if (transformedChunkSize != this.transformedChunkSize) {
            throw new IllegalArgumentException("Non-final chunk must be of size " + this.transformedChunkSize + ", but " + transformedChunkSize + " given");
        }
    }

    @Override
    protected ChunkIndex finish0(int finalTransformedChunkSize) {
        return new FixedSizeChunkIndex(this.originalChunkSize, this.originalFileSize, this.transformedChunkSize, finalTransformedChunkSize);
    }
}

