/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.manifest.index.AbstractChunkIndex;
import java.util.List;
import java.util.Objects;

public class FixedSizeChunkIndex
extends AbstractChunkIndex {
    @JsonProperty(value="transformedChunkSize")
    final int transformedChunkSize;
    private final List<Chunk> chunks;

    @JsonProperty(value="finalTransformedChunkSize")
    private int finalTransformedChunkSize() {
        return this.finalTransformedChunkSize;
    }

    @JsonCreator
    public FixedSizeChunkIndex(@JsonProperty(value="originalChunkSize", required=true) int originalChunkSize, @JsonProperty(value="originalFileSize", required=true) int originalFileSize, @JsonProperty(value="transformedChunkSize", required=true) int transformedChunkSize, @JsonProperty(value="finalTransformedChunkSize", required=true) int finalTransformedChunkSize) {
        super(originalChunkSize, originalFileSize, finalTransformedChunkSize, FixedSizeChunkIndex.chunkCount(originalChunkSize, originalFileSize));
        FixedSizeChunkIndex.checkSizeNonNegative(transformedChunkSize, "Transformed chunk size");
        this.transformedChunkSize = transformedChunkSize;
        this.chunks = this.materializeChunks();
    }

    private static int chunkCount(int originalChunkSize, int originalFileSize) {
        FixedSizeChunkIndex.checkSizePositive(originalChunkSize, "Original chunk size");
        return originalFileSize % originalChunkSize == 0 ? originalFileSize / originalChunkSize : originalFileSize / originalChunkSize + 1;
    }

    @Override
    public List<Chunk> chunks() {
        return this.chunks;
    }

    @Override
    protected final int transformedChunkSize(int chunkI) {
        boolean isFinalChunk = chunkI == this.chunkCount - 1;
        return isFinalChunk ? this.finalTransformedChunkSize : this.transformedChunkSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSizeChunkIndex that = (FixedSizeChunkIndex)o;
        return this.originalChunkSize == that.originalChunkSize && this.originalFileSize == that.originalFileSize && this.transformedChunkSize == that.transformedChunkSize && this.finalTransformedChunkSize == that.finalTransformedChunkSize;
    }

    public int hashCode() {
        return Objects.hash(this.originalChunkSize, this.originalFileSize, this.transformedChunkSize, this.finalTransformedChunkSize);
    }

    public String toString() {
        return "FixedSizeChunkIndex(originalChunkSize=" + this.originalChunkSize + ", originalFileSize=" + this.originalFileSize + ", transformedChunkSize=" + this.transformedChunkSize + ", finalTransformedChunkSize=" + this.finalTransformedChunkSize + ")";
    }
}

