/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index;

import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;

public abstract class AbstractChunkIndexBuilder {
    protected final int originalChunkSize;
    protected final int originalFileSize;
    private int chunksAdded = 0;
    private boolean finished = false;

    protected AbstractChunkIndexBuilder(int originalChunkSize, int originalFileSize) {
        this.checkSize(originalChunkSize, "Original chunk size");
        this.originalChunkSize = originalChunkSize;
        this.checkSize(originalFileSize, "Original file size");
        this.originalFileSize = originalFileSize;
    }

    public final void addChunk(int transformedChunkSize) {
        if (this.finished) {
            throw new IllegalStateException("Cannot add chunk to already finished index");
        }
        this.checkSize(transformedChunkSize, "Transformed chunk size");
        if (this.remainOfOriginalFileSize() <= this.originalChunkSize) {
            throw new IllegalStateException("This must be final chunk. Call `finish` instead.");
        }
        this.addChunk0(transformedChunkSize);
        ++this.chunksAdded;
    }

    protected abstract void addChunk0(int var1);

    public final ChunkIndex finish(int finalTransformedChunkSize) {
        if (this.finished) {
            throw new IllegalStateException("Cannot finish already finished index");
        }
        this.checkSize(finalTransformedChunkSize, "Transformed chunk size");
        if (this.remainOfOriginalFileSize() > this.originalChunkSize) {
            throw new IllegalStateException("This cannot be final chunk: not enough chunks to cover original file. Call `addChunk` instead.");
        }
        ChunkIndex result = this.finish0(finalTransformedChunkSize);
        ++this.chunksAdded;
        this.finished = true;
        return result;
    }

    protected abstract ChunkIndex finish0(int var1);

    protected final void checkSize(int size, String name) {
        if (size < 0) {
            throw new IllegalArgumentException(name + " must be non-negative, " + size + " given");
        }
    }

    protected final int remainOfOriginalFileSize() {
        return this.originalFileSize - this.chunksAdded * this.originalChunkSize;
    }
}

