/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest.index;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import io.aiven.kafka.tieredstorage.storage.BytesRange;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractChunkIndex
implements ChunkIndex {
    @JsonProperty(value="originalChunkSize")
    protected final int originalChunkSize;
    @JsonProperty(value="originalFileSize")
    protected final int originalFileSize;
    protected final int finalTransformedChunkSize;
    protected final int chunkCount;

    protected AbstractChunkIndex(int originalChunkSize, int originalFileSize, int finalTransformedChunkSize, int chunkCount) {
        AbstractChunkIndex.checkSizePositive(originalChunkSize, "Original chunk size");
        this.originalChunkSize = originalChunkSize;
        AbstractChunkIndex.checkSizeNonNegative(originalFileSize, "Original file size");
        this.originalFileSize = originalFileSize;
        AbstractChunkIndex.checkSizeNonNegative(finalTransformedChunkSize, "Final transformed chunk size");
        this.finalTransformedChunkSize = finalTransformedChunkSize;
        this.chunkCount = chunkCount;
    }

    protected final List<Chunk> materializeChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(this.chunkCount);
        int originalPosition = 0;
        int transformedPosition = 0;
        if (this.chunkCount == 0) {
            chunks.add(new Chunk(0, 0, 0, 0, 0));
        } else {
            for (int chunkI = 0; chunkI < this.chunkCount; ++chunkI) {
                int originalSize = this.originalChunkSize(chunkI);
                int transformedSize = this.transformedChunkSize(chunkI);
                chunks.add(new Chunk(chunkI, originalPosition, originalSize, transformedPosition, transformedSize));
                originalPosition += originalSize;
                transformedPosition += transformedSize;
            }
        }
        return List.copyOf(chunks);
    }

    @Override
    public Chunk findChunkForOriginalOffset(int offset) {
        int firstOffsetBeyondCurOriginalChunk;
        int chunkI;
        this.checkOffset(offset);
        if (offset >= this.originalFileSize) {
            return null;
        }
        int curOriginalChunkPosition = 0;
        int curTransformedChunkPosition = 0;
        for (chunkI = 0; chunkI < this.chunkCount && offset >= (firstOffsetBeyondCurOriginalChunk = (chunkI + 1) * this.originalChunkSize); ++chunkI) {
            curOriginalChunkPosition += this.originalChunkSize(chunkI);
            curTransformedChunkPosition += this.transformedChunkSize(chunkI);
        }
        return new Chunk(chunkI, curOriginalChunkPosition, this.originalChunkSize(chunkI), curTransformedChunkPosition, this.transformedChunkSize(chunkI));
    }

    @Override
    public List<Chunk> chunksForRange(BytesRange bytesRange) {
        Chunk current;
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        for (int i = bytesRange.firstPosition(); i <= bytesRange.lastPosition() && i < this.originalFileSize; i += current.originalSize) {
            current = this.findChunkForOriginalOffset(i);
            result.add(current);
        }
        return result;
    }

    private int originalChunkSize(int chunkI) {
        boolean isFinalChunk = chunkI == this.chunkCount - 1;
        return isFinalChunk ? this.originalFileSize - (this.chunkCount - 1) * this.originalChunkSize : this.originalChunkSize;
    }

    protected abstract int transformedChunkSize(int var1);

    protected static void checkSizeNonNegative(int size, String name) {
        if (size < 0) {
            throw new IllegalArgumentException(name + " must be non-negative, " + size + " given");
        }
    }

    protected static void checkSizePositive(int size, String name) {
        if (size <= 0) {
            throw new IllegalArgumentException(name + " must be positive, " + size + " given");
        }
    }

    protected final void checkOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be non-negative, " + offset + " given");
        }
    }
}

