/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.manifest.SegmentEncryptionMetadata;
import io.aiven.kafka.tieredstorage.manifest.SegmentEncryptionMetadataV1;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexes;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexesV1;
import io.aiven.kafka.tieredstorage.manifest.SegmentManifest;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;

public class SegmentManifestV1
implements SegmentManifest {
    private final ChunkIndex chunkIndex;
    private final SegmentIndexesV1 segmentIndexes;
    private final boolean compression;
    private final SegmentEncryptionMetadataV1 encryption;
    private final RemoteLogSegmentMetadata remoteLogSegmentMetadata;

    @JsonCreator
    public SegmentManifestV1(@JsonProperty(value="chunkIndex", required=true) ChunkIndex chunkIndex, @JsonProperty(value="segmentIndexes", required=true) SegmentIndexesV1 segmentIndexes, @JsonProperty(value="compression", required=true) boolean compression, @JsonProperty(value="encryption") SegmentEncryptionMetadataV1 encryption) {
        this(chunkIndex, segmentIndexes, compression, encryption, null);
    }

    public SegmentManifestV1(ChunkIndex chunkIndex, SegmentIndexesV1 segmentIndexes, boolean compression, SegmentEncryptionMetadataV1 encryption, RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        this.chunkIndex = Objects.requireNonNull(chunkIndex, "chunkIndex cannot be null");
        this.segmentIndexes = Objects.requireNonNull(segmentIndexes, "segmentIndexes cannot be null");
        this.compression = compression;
        this.encryption = encryption;
        this.remoteLogSegmentMetadata = remoteLogSegmentMetadata;
    }

    @Override
    @JsonProperty(value="chunkIndex")
    public ChunkIndex chunkIndex() {
        return this.chunkIndex;
    }

    @Override
    @JsonProperty(value="segmentIndexes")
    public SegmentIndexes segmentIndexes() {
        return this.segmentIndexes;
    }

    @Override
    @JsonProperty(value="compression")
    public boolean compression() {
        return this.compression;
    }

    @Override
    @JsonProperty(value="encryption")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<SegmentEncryptionMetadata> encryption() {
        return Optional.ofNullable(this.encryption);
    }

    @Override
    @JsonProperty(value="remoteLogSegmentMetadata", access=JsonProperty.Access.READ_ONLY)
    public RemoteLogSegmentMetadata remoteLogSegmentMetadata() {
        return this.remoteLogSegmentMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentManifestV1 that = (SegmentManifestV1)o;
        if (this.compression != that.compression) {
            return false;
        }
        if (!this.chunkIndex.equals(that.chunkIndex)) {
            return false;
        }
        return Objects.equals(this.encryption, that.encryption);
    }

    public int hashCode() {
        int result = this.chunkIndex.hashCode();
        result = 31 * result + (this.compression ? 1 : 0);
        result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SegmentManifestV1(chunkIndex=" + String.valueOf(this.chunkIndex) + ", segmentIndexes=" + String.valueOf(this.segmentIndexes) + ", compression=" + this.compression + ", encryption=" + String.valueOf(this.encryption) + ")";
    }
}

