/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest;

import io.aiven.kafka.tieredstorage.manifest.SegmentIndexV1;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexesV1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;

public class SegmentIndexesV1Builder {
    private final Map<RemoteStorageManager.IndexType, SegmentIndexV1> indexes = new HashMap<RemoteStorageManager.IndexType, SegmentIndexV1>(RemoteStorageManager.IndexType.values().length);
    private int currentPosition = 0;

    public SegmentIndexesV1Builder add(RemoteStorageManager.IndexType indexType, int size) {
        if (this.indexes.containsKey((Object)indexType)) {
            throw new IllegalStateException("Index " + String.valueOf((Object)indexType) + " is already added");
        }
        this.indexes.put(indexType, new SegmentIndexV1(this.currentPosition, size));
        this.currentPosition += size;
        return this;
    }

    public List<RemoteStorageManager.IndexType> indexes() {
        ArrayList<RemoteStorageManager.IndexType> indexTypes = new ArrayList<RemoteStorageManager.IndexType>(this.indexes.keySet());
        Collections.sort(indexTypes);
        return indexTypes;
    }

    public SegmentIndexesV1 build() {
        if (this.indexes.size() < 4) {
            throw new IllegalStateException("Not enough indexes have been added; at least 4 required. Indexes included: " + String.valueOf(this.indexes()));
        }
        if (this.indexes.size() == 4 && this.indexes.containsKey((Object)RemoteStorageManager.IndexType.TRANSACTION)) {
            throw new IllegalStateException("OFFSET, TIMESTAMP, PRODUCER_SNAPSHOT, and LEADER_EPOCH indexes are required");
        }
        return new SegmentIndexesV1(this.indexes.get((Object)RemoteStorageManager.IndexType.OFFSET), this.indexes.get((Object)RemoteStorageManager.IndexType.TIMESTAMP), this.indexes.get((Object)RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT), this.indexes.get((Object)RemoteStorageManager.IndexType.LEADER_EPOCH), this.indexes.get((Object)RemoteStorageManager.IndexType.TRANSACTION));
    }
}

