/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndex;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexV1;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexes;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndexesV1Builder;
import java.util.Objects;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;

public class SegmentIndexesV1
implements SegmentIndexes {
    private final SegmentIndexV1 offset;
    private final SegmentIndexV1 timestamp;
    private final SegmentIndexV1 producerSnapshot;
    private final SegmentIndexV1 leaderEpoch;
    private final SegmentIndexV1 transaction;

    @JsonCreator
    public SegmentIndexesV1(@JsonProperty(value="offset", required=true) SegmentIndexV1 offset, @JsonProperty(value="timestamp", required=true) SegmentIndexV1 timestamp, @JsonProperty(value="producerSnapshot", required=true) SegmentIndexV1 producerSnapshot, @JsonProperty(value="leaderEpoch", required=true) SegmentIndexV1 leaderEpoch, @JsonProperty(value="transaction", required=true) SegmentIndexV1 transaction) {
        this.offset = Objects.requireNonNull(offset, "offset cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp cannot be null");
        this.producerSnapshot = Objects.requireNonNull(producerSnapshot, "producerSnapshot cannot be null");
        this.leaderEpoch = Objects.requireNonNull(leaderEpoch, "leaderEpoch cannot be null");
        this.transaction = transaction;
    }

    public static SegmentIndexesV1Builder builder() {
        return new SegmentIndexesV1Builder();
    }

    @Override
    @JsonProperty(value="offset")
    public SegmentIndex offset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="timestamp")
    public SegmentIndex timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="producerSnapshot")
    public SegmentIndex producerSnapshot() {
        return this.producerSnapshot;
    }

    @Override
    @JsonProperty(value="leaderEpoch")
    public SegmentIndex leaderEpoch() {
        return this.leaderEpoch;
    }

    @Override
    @JsonProperty(value="transaction")
    public SegmentIndex transaction() {
        return this.transaction;
    }

    @Override
    public SegmentIndex segmentIndex(RemoteStorageManager.IndexType indexType) {
        switch (indexType) {
            case OFFSET: {
                return this.offset;
            }
            case TIMESTAMP: {
                return this.timestamp;
            }
            case PRODUCER_SNAPSHOT: {
                return this.producerSnapshot;
            }
            case LEADER_EPOCH: {
                return this.leaderEpoch;
            }
            case TRANSACTION: {
                return this.transaction;
            }
        }
        throw new IllegalArgumentException("Unknown index type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentIndexesV1 that = (SegmentIndexesV1)o;
        return Objects.equals(this.offset, that.offset) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.producerSnapshot, that.producerSnapshot) && Objects.equals(this.leaderEpoch, that.leaderEpoch) && Objects.equals(this.transaction, that.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.timestamp, this.producerSnapshot, this.leaderEpoch, this.transaction);
    }

    public String toString() {
        return "SegmentIndexesV1{offset=" + String.valueOf(this.offset) + ", timestamp=" + String.valueOf(this.timestamp) + ", producerSnapshot=" + String.valueOf(this.producerSnapshot) + ", leaderEpoch=" + String.valueOf(this.leaderEpoch) + ", transaction=" + String.valueOf(this.transaction) + "}";
    }
}

