/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.manifest.SegmentIndex;
import io.aiven.kafka.tieredstorage.storage.BytesRange;
import java.util.Objects;

public class SegmentIndexV1
implements SegmentIndex {
    private final int position;
    private final int size;

    @JsonCreator
    public SegmentIndexV1(@JsonProperty(value="position", required=true) int position, @JsonProperty(value="size", required=true) int size) {
        this.position = position;
        this.size = size;
    }

    @Override
    @JsonProperty(value="position")
    public int position() {
        return this.position;
    }

    @Override
    @JsonProperty(value="size")
    public int size() {
        return this.size;
    }

    @Override
    public BytesRange range() {
        return BytesRange.ofFromPositionAndSize(this.position, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentIndexV1 that = (SegmentIndexV1)o;
        return this.position == that.position && this.size == that.size;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.size);
    }

    public String toString() {
        return "SegmentIndexV1{position=" + this.position + ", size=" + this.size + "}";
    }
}

