/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.aiven.kafka.tieredstorage.manifest.SegmentEncryptionMetadata;
import io.aiven.kafka.tieredstorage.security.DataKeyAndAAD;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKey;

public class SegmentEncryptionMetadataV1
implements SegmentEncryptionMetadata {
    public static final int IV_SIZE = 12;
    private final SecretKey dataKey;
    private final byte[] aad;

    @JsonCreator
    public SegmentEncryptionMetadataV1(@JsonProperty(value="dataKey", required=true) SecretKey dataKey, @JsonProperty(value="aad", required=true) byte[] aad) {
        this.dataKey = Objects.requireNonNull(dataKey, "dataKey cannot be null");
        this.aad = Objects.requireNonNull(aad, "aad cannot be null");
    }

    public SegmentEncryptionMetadataV1(DataKeyAndAAD dataKeyAndAAD) {
        this(dataKeyAndAAD.dataKey, dataKeyAndAAD.aad);
    }

    @Override
    public int ivSize() {
        return 12;
    }

    @Override
    @JsonProperty(value="dataKey")
    public SecretKey dataKey() {
        return this.dataKey;
    }

    @Override
    @JsonProperty(value="aad")
    public byte[] aad() {
        return this.aad;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentEncryptionMetadataV1 that = (SegmentEncryptionMetadataV1)o;
        if (!this.dataKey.equals(that.dataKey)) {
            return false;
        }
        return Arrays.equals(this.aad, that.aad);
    }

    public int hashCode() {
        int result = this.dataKey.hashCode();
        result = 31 * result + Arrays.hashCode(this.aad);
        return result;
    }

    public String toString() {
        return "SegmentEncryptionMetadataV1(dataKey=" + String.valueOf(this.dataKey) + ", aad=" + Arrays.toString(this.aad) + ")";
    }
}

