/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch.cache;

import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import io.aiven.kafka.tieredstorage.config.ChunkCacheConfig;
import io.aiven.kafka.tieredstorage.fetch.ChunkKey;
import io.aiven.kafka.tieredstorage.fetch.ChunkManager;
import io.aiven.kafka.tieredstorage.fetch.cache.ChunkCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryChunkCache
extends ChunkCache<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(MemoryChunkCache.class);

    public MemoryChunkCache(ChunkManager chunkManager) {
        super(chunkManager);
    }

    @Override
    public InputStream cachedChunkToInputStream(byte[] cachedChunk) {
        return new ByteArrayInputStream(cachedChunk);
    }

    @Override
    public byte[] cacheChunk(ChunkKey chunkKey, InputStream chunk) throws IOException {
        try (InputStream inputStream = chunk;){
            byte[] byArray = chunk.readAllBytes();
            return byArray;
        }
    }

    @Override
    public RemovalListener<ChunkKey, byte[]> removalListener() {
        return (key, content, cause) -> log.debug("Deleted cached value for key {} from cache. The reason of the deletion is {}", key, (Object)cause);
    }

    @Override
    public Weigher<ChunkKey, byte[]> weigher() {
        return (key, value) -> ((byte[])value).length;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        ChunkCacheConfig config = new ChunkCacheConfig(configs);
        this.cache = this.buildCache(config);
    }
}

