/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch.cache;

import java.util.List;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;

class DiskChunkCacheMetrics {
    private static final String METRIC_GROUP = "disk-chunk-cache-metrics";
    private final Metrics metrics;
    private final Sensor writes;
    private final Sensor writeBytes;
    private final Sensor deletes;
    private final Sensor deleteBytes;

    DiskChunkCacheMetrics(Time time) {
        JmxReporter reporter = new JmxReporter();
        this.metrics = new Metrics(new MetricConfig(), List.of(reporter), time, new KafkaMetricsContext("aiven.kafka.server.tieredstorage.cache"));
        this.writes = this.createSensor("write");
        this.writeBytes = this.createSensor("write-bytes");
        this.deletes = this.createSensor("delete");
        this.deleteBytes = this.createSensor("delete-bytes");
    }

    private Sensor createSensor(String name) {
        Sensor sensor = this.metrics.sensor(name);
        sensor.add(this.metrics.metricName(name + "-rate", METRIC_GROUP), new Rate());
        sensor.add(this.metrics.metricName(name + "-total", METRIC_GROUP), new CumulativeSum());
        return sensor;
    }

    void chunkWritten(long bytesWritten) {
        this.writes.record(1.0);
        this.writeBytes.record(bytesWritten);
    }

    void chunkDeleted(long chunkSize) {
        this.deletes.record(1.0);
        this.deleteBytes.record(chunkSize);
    }
}

