/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch.cache;

import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import io.aiven.kafka.tieredstorage.config.DiskChunkCacheConfig;
import io.aiven.kafka.tieredstorage.fetch.ChunkKey;
import io.aiven.kafka.tieredstorage.fetch.ChunkManager;
import io.aiven.kafka.tieredstorage.fetch.cache.ChunkCache;
import io.aiven.kafka.tieredstorage.fetch.cache.DiskChunkCacheMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskChunkCache
extends ChunkCache<Path> {
    private static final Logger log = LoggerFactory.getLogger(DiskChunkCache.class);
    private final DiskChunkCacheMetrics metrics;
    private DiskChunkCacheConfig config;

    public DiskChunkCache(ChunkManager chunkManager) {
        this(chunkManager, Time.SYSTEM);
    }

    DiskChunkCache(ChunkManager chunkManager, Time time) {
        super(chunkManager);
        this.metrics = new DiskChunkCacheMetrics(time);
    }

    @Override
    public InputStream cachedChunkToInputStream(Path cachedChunk) {
        try {
            return Files.newInputStream(cachedChunk, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path cacheChunk(ChunkKey chunkKey, InputStream chunk) throws IOException {
        String chunkKeyPath = chunkKey.path();
        Path tempChunkPath = this.config.tempCachePath().resolve(chunkKeyPath);
        Path tempCached = this.writeToDisk(chunk, tempChunkPath);
        log.trace("Chunk file has been stored to temporary caching directory {}", (Object)tempCached);
        Path cachedChunkPath = this.config.cachePath().resolve(chunkKeyPath);
        try {
            Path newPath = Files.move(tempCached, cachedChunkPath, StandardCopyOption.ATOMIC_MOVE);
            log.trace("Chunk file has been moved to cache directory {}", (Object)newPath);
            Path path = newPath;
            return path;
        }
        finally {
            if (Files.exists(tempCached, new LinkOption[0])) {
                log.error("Failed to move chunk file {} to cache directory from temporary one.", (Object)tempCached);
                Files.delete(tempCached);
            }
        }
    }

    private Path writeToDisk(InputStream chunk, Path tempChunkPath) throws IOException {
        try (InputStream inputStream = chunk;
             OutputStream out = Files.newOutputStream(tempChunkPath, new OpenOption[0]);){
            long bytesTransferred = chunk.transferTo(out);
            this.metrics.chunkWritten(bytesTransferred);
        }
        return tempChunkPath;
    }

    @Override
    public RemovalListener<ChunkKey, Path> removalListener() {
        return (key, path, cause) -> {
            try {
                if (path != null) {
                    long fileSize = Files.size(path);
                    try {
                        Files.delete(path);
                        this.metrics.chunkDeleted(fileSize);
                        log.trace("Deleted cached file for key {} with path {} from cache directory. The reason of the deletion is {}", new Object[]{key, path, cause});
                    }
                    catch (IOException ex) {
                        log.warn("Cannot delete file {} for key {}", path, key, ex);
                    }
                } else {
                    log.warn("Path not present when trying to delete cached file for key {} from cache directory. The reason of the deletion is {}", key, (Object)cause);
                }
            }
            catch (IOException e) {
                log.error("Failed to delete cached file for key {} with path {} from cache directory. The reason of the deletion is {}", new Object[]{key, path, cause, e});
            }
        };
    }

    @Override
    public Weigher<ChunkKey, Path> weigher() {
        return (key, value) -> {
            try {
                long fileSize = Files.size(value);
                if (fileSize <= Integer.MAX_VALUE) {
                    return (int)fileSize;
                }
                log.warn("Cache size calculation have been inaccurate because size of a cached file was bigger than Integer.MAX_VALUE. This should never happen.");
                return Integer.MAX_VALUE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.config = new DiskChunkCacheConfig(configs);
        this.cache = this.buildCache(this.config);
    }
}

