/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch;

import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.fetch.ChunkManager;
import io.aiven.kafka.tieredstorage.fetch.KeyNotFoundRuntimeException;
import io.aiven.kafka.tieredstorage.manifest.SegmentManifest;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import io.aiven.kafka.tieredstorage.storage.BytesRange;
import io.aiven.kafka.tieredstorage.storage.KeyNotFoundException;
import io.aiven.kafka.tieredstorage.storage.ObjectKey;
import io.aiven.kafka.tieredstorage.storage.StorageBackendException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.io.input.BoundedInputStream;

public class FetchChunkEnumeration
implements Enumeration<InputStream> {
    private final ChunkManager chunkManager;
    private final ObjectKey objectKey;
    private final SegmentManifest manifest;
    private final BytesRange range;
    final int startChunkId;
    final int lastChunkId;
    private final ChunkIndex chunkIndex;
    int currentChunkId;
    public boolean closed;

    public FetchChunkEnumeration(ChunkManager chunkManager, ObjectKey objectKey, SegmentManifest manifest, BytesRange range) {
        this.chunkManager = Objects.requireNonNull(chunkManager, "chunkManager cannot be null");
        this.objectKey = Objects.requireNonNull(objectKey, "objectKey cannot be null");
        this.manifest = Objects.requireNonNull(manifest, "manifest cannot be null");
        this.range = Objects.requireNonNull(range, "range cannot be null");
        this.chunkIndex = manifest.chunkIndex();
        if (range.isEmpty()) {
            throw new IllegalArgumentException("range cannot be empty");
        }
        Chunk firstChunk = this.getFirstChunk(range.firstPosition());
        this.currentChunkId = this.startChunkId = firstChunk.id;
        Chunk lastChunk = this.getLastChunk(range.lastPosition());
        this.lastChunkId = lastChunk.id;
    }

    private Chunk getFirstChunk(int fromPosition) {
        Chunk firstChunk = this.chunkIndex.findChunkForOriginalOffset(fromPosition);
        if (firstChunk == null) {
            throw new IllegalArgumentException("Invalid start position " + fromPosition + " in segment path " + String.valueOf(this.objectKey));
        }
        return firstChunk;
    }

    private Chunk getLastChunk(int endPosition) {
        Chunk chunkForOriginalOffset = this.chunkIndex.findChunkForOriginalOffset(endPosition);
        if (chunkForOriginalOffset == null) {
            List<Chunk> chunks = this.chunkIndex.chunks();
            return chunks.get(chunks.size() - 1);
        }
        return chunkForOriginalOffset;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.closed && this.currentChunkId <= this.lastChunkId;
    }

    @Override
    public InputStream nextElement() {
        boolean isSingleChunk;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        InputStream chunkContent = this.getChunkContent(this.currentChunkId);
        Chunk currentChunk = this.chunkIndex.chunks().get(this.currentChunkId);
        int chunkStartPosition = currentChunk.originalPosition;
        boolean isAtFirstChunk = this.currentChunkId == this.startChunkId;
        boolean isAtLastChunk = this.currentChunkId == this.lastChunkId;
        boolean bl = isSingleChunk = isAtFirstChunk && isAtLastChunk;
        if (isSingleChunk) {
            int toSkip = this.range.firstPosition() - chunkStartPosition;
            try {
                chunkContent.skip(toSkip);
                int chunkSize = this.range.size();
                chunkContent = new BoundedInputStream(chunkContent, chunkSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (isAtFirstChunk) {
            int toSkip = this.range.firstPosition() - chunkStartPosition;
            try {
                chunkContent.skip(toSkip);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (isAtLastChunk) {
            int chunkSize = this.range.lastPosition() - chunkStartPosition + 1;
            chunkContent = new BoundedInputStream(chunkContent, chunkSize);
        }
        ++this.currentChunkId;
        return chunkContent;
    }

    private InputStream getChunkContent(int chunkId) {
        try {
            return this.chunkManager.getChunk(this.objectKey, this.manifest, chunkId);
        }
        catch (KeyNotFoundException e) {
            throw new KeyNotFoundRuntimeException(e);
        }
        catch (StorageBackendException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream toInputStream() {
        return new LazySequenceInputStream(this);
    }

    public void close() {
        this.closed = true;
    }

    private static class LazySequenceInputStream
    extends SequenceInputStream {
        private final FetchChunkEnumeration closeableEnumeration;

        LazySequenceInputStream(FetchChunkEnumeration e) {
            super(e);
            this.closeableEnumeration = e;
        }

        @Override
        public void close() throws IOException {
            this.closeableEnumeration.close();
            super.close();
        }
    }
}

