/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch;

import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.fetch.ChunkManager;
import io.aiven.kafka.tieredstorage.manifest.SegmentEncryptionMetadata;
import io.aiven.kafka.tieredstorage.manifest.SegmentManifest;
import io.aiven.kafka.tieredstorage.security.AesEncryptionProvider;
import io.aiven.kafka.tieredstorage.storage.ObjectFetcher;
import io.aiven.kafka.tieredstorage.storage.ObjectKey;
import io.aiven.kafka.tieredstorage.storage.StorageBackendException;
import io.aiven.kafka.tieredstorage.transform.BaseDetransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DecompressionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DecryptionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DetransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DetransformFinisher;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;

public class DefaultChunkManager
implements ChunkManager {
    private final ObjectFetcher fetcher;
    private final AesEncryptionProvider aesEncryptionProvider;

    public DefaultChunkManager(ObjectFetcher fetcher, AesEncryptionProvider aesEncryptionProvider) {
        this.fetcher = fetcher;
        this.aesEncryptionProvider = aesEncryptionProvider;
    }

    @Override
    public InputStream getChunk(ObjectKey objectKey, SegmentManifest manifest, int chunkId) throws StorageBackendException {
        Chunk chunk = manifest.chunkIndex().chunks().get(chunkId);
        InputStream chunkContent = this.fetcher.fetch(objectKey, chunk.range());
        DetransformChunkEnumeration detransformEnum = new BaseDetransformChunkEnumeration(chunkContent, List.of(chunk));
        Optional<SegmentEncryptionMetadata> encryptionMetadata = manifest.encryption();
        if (encryptionMetadata.isPresent()) {
            detransformEnum = new DecryptionChunkEnumeration(detransformEnum, encryptionMetadata.get().ivSize(), encryptedChunk -> this.aesEncryptionProvider.decryptionCipher((byte[])encryptedChunk, (SegmentEncryptionMetadata)encryptionMetadata.get()));
        }
        if (manifest.compression()) {
            detransformEnum = new DecompressionChunkEnumeration(detransformEnum);
        }
        DetransformFinisher detransformFinisher = new DetransformFinisher(detransformEnum);
        return detransformFinisher.toInputStream();
    }
}

