/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch;

import io.aiven.kafka.tieredstorage.config.ChunkManagerFactoryConfig;
import io.aiven.kafka.tieredstorage.fetch.ChunkManager;
import io.aiven.kafka.tieredstorage.fetch.DefaultChunkManager;
import io.aiven.kafka.tieredstorage.fetch.cache.ChunkCache;
import io.aiven.kafka.tieredstorage.security.AesEncryptionProvider;
import io.aiven.kafka.tieredstorage.storage.ObjectFetcher;
import java.util.Map;
import org.apache.kafka.common.Configurable;

public class ChunkManagerFactory
implements Configurable {
    private ChunkManagerFactoryConfig config;

    @Override
    public void configure(Map<String, ?> configs) {
        this.config = new ChunkManagerFactoryConfig(configs);
    }

    public ChunkManager initChunkManager(ObjectFetcher fileFetcher, AesEncryptionProvider aesEncryptionProvider) {
        DefaultChunkManager defaultChunkManager = new DefaultChunkManager(fileFetcher, aesEncryptionProvider);
        if (this.config.cacheClass() != null) {
            try {
                ChunkCache<?> chunkCache = this.config.cacheClass().getDeclaredConstructor(ChunkManager.class).newInstance(defaultChunkManager);
                chunkCache.configure(this.config.originalsWithPrefix("fetch.chunk.cache."));
                return chunkCache;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return defaultChunkManager;
    }
}

