/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.fetch;

import java.nio.file.Path;
import java.util.Objects;

public class ChunkKey {
    public final String segmentFileName;
    public final int chunkId;

    public ChunkKey(String objectKeyPath, int chunkId) {
        Objects.requireNonNull(objectKeyPath, "objectKeyPath cannot be null");
        this.segmentFileName = Path.of(objectKeyPath, new String[0]).getFileName().toString();
        this.chunkId = chunkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkKey chunkKey = (ChunkKey)o;
        if (this.chunkId != chunkKey.chunkId) {
            return false;
        }
        return Objects.equals(this.segmentFileName, chunkKey.segmentFileName);
    }

    public int hashCode() {
        int result = this.segmentFileName.hashCode();
        result = 31 * result + this.chunkId;
        return result;
    }

    public String toString() {
        return "ChunkKey(segmentFileName=" + this.segmentFileName + ", chunkId=" + this.chunkId + ")";
    }

    public String path() {
        return this.segmentFileName + "-" + this.chunkId;
    }
}

