/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config.validators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ValidUrl
implements ConfigDef.Validator {
    private static final List<String> SUPPORTED_SCHEMAS = List.of("http", "https");

    @Override
    public void ensureValid(String name, Object value) {
        if (value != null) {
            try {
                URL url = new URL((String)value);
                if (!SUPPORTED_SCHEMAS.contains(url.getProtocol())) {
                    throw new ConfigException(name, value, "URL must have scheme from the list " + SUPPORTED_SCHEMAS);
                }
            }
            catch (MalformedURLException e) {
                throw new ConfigException(name, value, "Must be a valid URL");
            }
        }
    }

    public String toString() {
        return "Valid URL as defined in rfc2396";
    }
}

