/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config.validators;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class Subclass
implements ConfigDef.Validator {
    private final Class<?> parentClass;

    public static Subclass of(Class<?> parentClass) {
        return new Subclass(parentClass);
    }

    public Subclass(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    @Override
    public void ensureValid(String name, Object value) {
        if (value != null && !this.parentClass.isAssignableFrom((Class)value)) {
            throw new ConfigException(name + " should be a subclass of " + this.parentClass.getCanonicalName());
        }
    }

    public String toString() {
        return "Any implementation of " + this.parentClass.getName();
    }
}

