/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config;

import io.aiven.kafka.tieredstorage.config.KeyPairPaths;
import io.aiven.kafka.tieredstorage.config.validators.Null;
import io.aiven.kafka.tieredstorage.metadata.SegmentCustomMetadataField;
import io.aiven.kafka.tieredstorage.storage.StorageBackend;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;

public class RemoteStorageManagerConfig
extends AbstractConfig {
    public static final String STORAGE_PREFIX = "storage.";
    public static final String FETCH_INDEXES_CACHE_PREFIX = "fetch.indexes.cache.";
    public static final String SEGMENT_MANIFEST_CACHE_PREFIX = "fetch.manifest.cache.";
    private static final String STORAGE_BACKEND_CLASS_CONFIG = "storage.backend.class";
    private static final String STORAGE_BACKEND_CLASS_DOC = "The storage backend implementation class";
    private static final String OBJECT_KEY_PREFIX_CONFIG = "key.prefix";
    private static final String OBJECT_KEY_PREFIX_DOC = "The object storage path prefix";
    private static final String OBJECT_KEY_PREFIX_MASK_CONFIG = "key.prefix.mask";
    private static final String OBJECT_KEY_PREFIX_MASK_DOC = "Whether to mask path prefix in logs";
    private static final String CHUNK_SIZE_CONFIG = "chunk.size";
    private static final String CHUNK_SIZE_DOC = "Segment files are chunked into smaller parts to allow for faster processing (e.g. encryption, compression) and for range-fetching. It is recommended to benchmark this value, starting with 4MiB.";
    private static final String COMPRESSION_ENABLED_CONFIG = "compression.enabled";
    private static final String COMPRESSION_ENABLED_DOC = "Segments can be further compressed to optimize storage usage. Disabled by default.";
    private static final String COMPRESSION_HEURISTIC_ENABLED_CONFIG = "compression.heuristic.enabled";
    private static final String COMPRESSION_HEURISTIC_ENABLED_DOC = "Only compress segments where native compression has not been enabled. This is currently validated by looking into the first batch header. Only enabled if compression.enabled is enabled.";
    private static final String ENCRYPTION_CONFIG = "encryption.enabled";
    private static final String ENCRYPTION_DOC = "Segments and indexes can be encrypted, so objects are not accessible by accessing the remote storage. Disabled by default.";
    private static final String CUSTOM_METADATA_FIELDS_INCLUDE_CONFIG = "custom.metadata.fields.include";
    private static final String CUSTOM_METADATA_FIELDS_INCLUDE_DOC = "Custom Metadata to be stored along Remote Log Segment metadata on Remote Log Metadata Manager back-end. Allowed values: " + Arrays.toString(SegmentCustomMetadataField.names());
    private static final String UPLOAD_RATE_LIMIT_BYTES_CONFIG = "upload.rate.limit.bytes.per.second";
    private static final String UPLOAD_RATE_LIMIT_BYTES_DOC = "Upper bound on bytes to upload (therefore read from disk) per second. Rate limit must be equal or larger than 1 MiB/sec as minimal upload throughput.";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    private static final String METRICS_NUM_SAMPLES_DOC = "The number of samples maintained to compute metrics.";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    private static final String METRICS_SAMPLE_WINDOW_MS_DOC = "The window of time a metrics sample is computed over.";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    private static final String METRICS_RECORDING_LEVEL_DOC = "The highest recording level for metrics.";
    private final EncryptionConfig encryptionConfig;

    public static ConfigDef configDef() {
        ConfigDef configDef = new ConfigDef();
        configDef.define(STORAGE_BACKEND_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, STORAGE_BACKEND_CLASS_DOC);
        configDef.define(OBJECT_KEY_PREFIX_CONFIG, ConfigDef.Type.STRING, "", new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, OBJECT_KEY_PREFIX_DOC);
        configDef.define(OBJECT_KEY_PREFIX_MASK_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, OBJECT_KEY_PREFIX_MASK_DOC);
        configDef.define(CHUNK_SIZE_CONFIG, ConfigDef.Type.INT, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Range.between(1, 0x3FFFFFFF), ConfigDef.Importance.HIGH, CHUNK_SIZE_DOC);
        configDef.define(COMPRESSION_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, COMPRESSION_ENABLED_DOC);
        configDef.define(COMPRESSION_HEURISTIC_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, COMPRESSION_HEURISTIC_ENABLED_DOC);
        configDef.define(ENCRYPTION_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, ENCRYPTION_DOC);
        configDef.define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, 30000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, METRICS_SAMPLE_WINDOW_MS_DOC);
        configDef.define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, 2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, METRICS_NUM_SAMPLES_DOC);
        configDef.define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, Sensor.RecordingLevel.INFO.toString(), ConfigDef.ValidString.in(Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString(), Sensor.RecordingLevel.TRACE.toString()), ConfigDef.Importance.LOW, METRICS_RECORDING_LEVEL_DOC);
        configDef.define(CUSTOM_METADATA_FIELDS_INCLUDE_CONFIG, ConfigDef.Type.LIST, "", ConfigDef.ValidList.in(SegmentCustomMetadataField.names()), ConfigDef.Importance.LOW, CUSTOM_METADATA_FIELDS_INCLUDE_DOC);
        configDef.define(UPLOAD_RATE_LIMIT_BYTES_CONFIG, ConfigDef.Type.INT, null, Null.or(ConfigDef.Range.atLeast(0x100000)), ConfigDef.Importance.MEDIUM, UPLOAD_RATE_LIMIT_BYTES_DOC);
        return configDef;
    }

    public OptionalInt uploadRateLimit() {
        return Optional.ofNullable(this.getInt(UPLOAD_RATE_LIMIT_BYTES_CONFIG)).stream().mapToInt(Integer::intValue).findAny();
    }

    public RemoteStorageManagerConfig(Map<String, ?> props) {
        super(RemoteStorageManagerConfig.configDef(), props);
        this.encryptionConfig = this.encryptionEnabled() ? EncryptionConfig.create(props) : null;
        this.validate();
    }

    private void validate() {
        this.validateCompression();
    }

    private void validateCompression() {
        if (this.getBoolean(COMPRESSION_HEURISTIC_ENABLED_CONFIG).booleanValue() && !this.getBoolean(COMPRESSION_ENABLED_CONFIG).booleanValue()) {
            throw new ConfigException("compression.enabled must be enabled if compression.heuristic.enabled is");
        }
    }

    public StorageBackend storage() {
        Class<?> storageClass = this.getClass(STORAGE_BACKEND_CLASS_CONFIG);
        StorageBackend storage = Utils.newInstance(storageClass, StorageBackend.class);
        storage.configure(this.originalsWithPrefix(STORAGE_PREFIX));
        return storage;
    }

    public String keyPrefix() {
        return this.getString(OBJECT_KEY_PREFIX_CONFIG);
    }

    public boolean keyPrefixMask() {
        return this.getBoolean(OBJECT_KEY_PREFIX_MASK_CONFIG);
    }

    public int chunkSize() {
        return this.getInt(CHUNK_SIZE_CONFIG);
    }

    public boolean compressionEnabled() {
        return this.getBoolean(COMPRESSION_ENABLED_CONFIG);
    }

    public boolean compressionHeuristicEnabled() {
        return this.getBoolean(COMPRESSION_HEURISTIC_ENABLED_CONFIG);
    }

    public boolean encryptionEnabled() {
        return this.getBoolean(ENCRYPTION_CONFIG);
    }

    public String encryptionKeyPairId() {
        if (!this.encryptionEnabled()) {
            return null;
        }
        return this.encryptionConfig.activeKeyPairId();
    }

    public Map<String, KeyPairPaths> encryptionKeyRing() {
        if (!this.encryptionEnabled()) {
            return null;
        }
        HashMap<String, KeyPairPaths> result = new HashMap<String, KeyPairPaths>();
        for (String keyPairId : this.encryptionConfig.keyPairIds()) {
            KeyPairPaths keyPair = new KeyPairPaths(this.encryptionConfig.encryptionPublicKeyFile(keyPairId), this.encryptionConfig.encryptionPrivateKeyFile(keyPairId));
            result.put(keyPairId, keyPair);
        }
        return result;
    }

    public Set<SegmentCustomMetadataField> customMetadataKeysIncluded() {
        return this.getList(CUSTOM_METADATA_FIELDS_INCLUDE_CONFIG).stream().map(SegmentCustomMetadataField::valueOf).collect(Collectors.toSet());
    }

    public Map<String, ?> fetchIndexesCacheConfigs() {
        return this.originalsWithPrefix(FETCH_INDEXES_CACHE_PREFIX);
    }

    public Map<String, ?> segmentManifestCacheConfigs() {
        return this.originalsWithPrefix(SEGMENT_MANIFEST_CACHE_PREFIX);
    }

    private static class EncryptionConfig
    extends AbstractConfig {
        private static final String ENCRYPTION_KEY_PAIR_ID_CONFIG = "encryption.key.pair.id";
        private static final String ENCRYPTION_KEY_PAIR_ID_DOC = "The ID of the key pair to be used for encryption";
        private static final String ENCRYPTION_KEY_PAIRS_CONFIG = "encryption.key.pairs";
        private static final String ENCRYPTION_KEY_PAIRS_DOC = "The list of encryption key pair IDs";
        private static final String ENCRYPTION_PUBLIC_KEY_FILE_DOC = "The path to the RSA public key file";
        private static final String ENCRYPTION_PRIVATE_KEY_FILE_DOC = "The path to the RSA private key file";

        private EncryptionConfig(ConfigDef configDef, Map<String, ?> props) {
            super(configDef, props);
        }

        Path encryptionPublicKeyFile(String keyPairId) {
            return Path.of(this.getString(EncryptionConfig.publicKeyFileConfig(keyPairId)), new String[0]);
        }

        Path encryptionPrivateKeyFile(String keyPairId) {
            return Path.of(this.getString(EncryptionConfig.privateKeyFileConfig(keyPairId)), new String[0]);
        }

        public static EncryptionConfig create(Map<String, ?> props) {
            ConfigDef configDef = new ConfigDef();
            configDef.define(ENCRYPTION_KEY_PAIR_ID_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, ENCRYPTION_KEY_PAIR_ID_DOC);
            configDef.define(ENCRYPTION_KEY_PAIRS_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, ENCRYPTION_KEY_PAIRS_DOC);
            EncryptionConfig interimEncryptionConfig = new EncryptionConfig(configDef, props);
            if (!interimEncryptionConfig.keyPairIds().contains(interimEncryptionConfig.activeKeyPairId())) {
                throw new ConfigException("Encryption key '" + interimEncryptionConfig.activeKeyPairId() + "' must be provided");
            }
            for (String keyPairId : interimEncryptionConfig.keyPairIds()) {
                configDef.define(EncryptionConfig.publicKeyFileConfig(keyPairId), ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, ENCRYPTION_PUBLIC_KEY_FILE_DOC);
                configDef.define(EncryptionConfig.privateKeyFileConfig(keyPairId), ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, ENCRYPTION_PRIVATE_KEY_FILE_DOC);
            }
            return new EncryptionConfig(configDef, props);
        }

        String activeKeyPairId() {
            return this.getString(ENCRYPTION_KEY_PAIR_ID_CONFIG);
        }

        List<String> keyPairIds() {
            return this.getList(ENCRYPTION_KEY_PAIRS_CONFIG);
        }

        private static String publicKeyFileConfig(String keyPairId) {
            return "encryption.key.pairs." + keyPairId + ".public.key.file";
        }

        private static String privateKeyFileConfig(String keyPairId) {
            return "encryption.key.pairs." + keyPairId + ".private.key.file";
        }
    }
}

