/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config;

import io.aiven.kafka.tieredstorage.config.ChunkCacheConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class DiskChunkCacheConfig
extends ChunkCacheConfig {
    private static final String CACHE_PATH_CONFIG = "path";
    private static final String CACHE_PATH_DOC = "Cache base directory. It is required to exist and be writable prior to the execution of the plugin.";
    public static final String TEMP_CACHE_DIRECTORY = "temp";
    public static final String CACHE_DIRECTORY = "cache";

    public static ConfigDef configDef() {
        return DiskChunkCacheConfig.configDef(new ConfigDef().define(CACHE_PATH_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, CACHE_PATH_DOC));
    }

    public DiskChunkCacheConfig(Map<String, ?> props) {
        super(DiskChunkCacheConfig.configDef(), props);
        Path baseCachePath = this.baseCachePath();
        if (!Files.isDirectory(baseCachePath, new LinkOption[0]) || !Files.isWritable(baseCachePath)) {
            throw new ConfigException(CACHE_PATH_CONFIG, baseCachePath, String.valueOf(baseCachePath) + " must exists and be a writable directory");
        }
        this.resetCacheDirectory();
    }

    private void resetCacheDirectory() {
        Path baseCachePath = this.baseCachePath();
        try {
            FileUtils.cleanDirectory(baseCachePath.toFile());
            Files.createDirectories(this.cachePath(), new FileAttribute[0]);
            Files.createDirectories(this.tempCachePath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ConfigException(CACHE_PATH_CONFIG, baseCachePath, "Failed to reset cache directory, please empty the directory, reason: " + String.valueOf(e));
        }
    }

    final Path baseCachePath() {
        return Path.of(this.getString(CACHE_PATH_CONFIG), new String[0]);
    }

    public final Path cachePath() {
        return this.baseCachePath().resolve(CACHE_DIRECTORY);
    }

    public final Path tempCachePath() {
        return this.baseCachePath().resolve(TEMP_CACHE_DIRECTORY);
    }
}

