/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config;

import io.aiven.kafka.tieredstorage.config.CacheConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class ChunkCacheConfig
extends CacheConfig {
    private static final String CACHE_PREFETCH_MAX_SIZE_CONFIG = "prefetch.max.size";
    private static final String CACHE_PREFETCH_MAX_SIZE_DOC = "The amount of data that should be eagerly prefetched and cached";
    private static final int CACHE_PREFETCHING_SIZE_DEFAULT = 0;

    public static final ConfigDef configDef(ConfigDef baseConfig) {
        baseConfig.define(CACHE_PREFETCH_MAX_SIZE_CONFIG, ConfigDef.Type.INT, 0, ConfigDef.Range.between(0, Integer.MAX_VALUE), ConfigDef.Importance.MEDIUM, CACHE_PREFETCH_MAX_SIZE_DOC);
        return CacheConfig.defBuilder(baseConfig).withDefaultRetentionMs(600000L).build();
    }

    public ChunkCacheConfig(ConfigDef configDef, Map<String, ?> props) {
        super(configDef, props);
    }

    public ChunkCacheConfig(Map<String, ?> props) {
        super(ChunkCacheConfig.configDef(new ConfigDef()), props);
    }

    public int cachePrefetchingSize() {
        return this.getInt(CACHE_PREFETCH_MAX_SIZE_CONFIG);
    }
}

