/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.config;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CacheConfig
extends AbstractConfig {
    private static final String CACHE_SIZE_CONFIG = "size";
    static final String CACHE_SIZE_DOC = "Cache size in bytes, where \"-1\" represents unbounded cache";
    private static final String CACHE_RETENTION_CONFIG = "retention.ms";
    private static final String CACHE_RETENTION_DOC = "Cache retention time ms, where \"-1\" represents infinite retention";
    private static final String CACHE_FETCH_THREAD_POOL_SIZE_CONFIG = "thread.pool.size";
    private static final String CACHE_FETCH_THREAD_POOL_SIZE_DOC = "Size for the thread pool used to schedule asynchronous fetching tasks, default to number of processors.";
    private static final String CACHE_FETCH_TIMEOUT_MS_CONFIG = "get.timeout.ms";
    private static final String CACHE_FETCH_TIMEOUT_MS_DOC = "When getting an object from the fetch, how long to wait before timing out. Defaults to 10 sec.";
    public static final long CACHE_RETENTION_MS_DEFAULT = 600000L;

    public CacheConfig(ConfigDef configDef, Map<String, ?> props) {
        super(configDef, props);
    }

    public static DefBuilder defBuilder() {
        return new DefBuilder();
    }

    public static DefBuilder defBuilder(ConfigDef baseConfig) {
        return new DefBuilder(baseConfig);
    }

    public Optional<Long> cacheSize() {
        Long rawValue = this.getLong(CACHE_SIZE_CONFIG);
        if (rawValue == -1L) {
            return Optional.empty();
        }
        return Optional.of(rawValue);
    }

    public Optional<Duration> cacheRetention() {
        Long rawValue = this.getLong(CACHE_RETENTION_CONFIG);
        if (rawValue == -1L) {
            return Optional.empty();
        }
        return Optional.of(Duration.ofMillis(rawValue));
    }

    public Optional<Integer> threadPoolSize() {
        Integer rawValue = this.getInt(CACHE_FETCH_THREAD_POOL_SIZE_CONFIG);
        if (rawValue == 0) {
            return Optional.empty();
        }
        return Optional.of(rawValue);
    }

    public Duration getTimeout() {
        return Duration.ofMillis(this.getLong(CACHE_FETCH_TIMEOUT_MS_CONFIG));
    }

    public static class DefBuilder {
        private long defaultRetentionMs = 600000L;
        private Object maybeDefaultSize = ConfigDef.NO_DEFAULT_VALUE;
        private String sizeDoc = "Cache size in bytes, where \"-1\" represents unbounded cache";
        final ConfigDef configDef;

        public DefBuilder() {
            this.configDef = new ConfigDef();
        }

        public DefBuilder(ConfigDef baseConfig) {
            this.configDef = baseConfig;
        }

        public DefBuilder withDefaultSize(long defaultSize) {
            this.maybeDefaultSize = defaultSize;
            return this;
        }

        public DefBuilder withDefaultRetentionMs(long retentionMs) {
            this.defaultRetentionMs = retentionMs;
            return this;
        }

        public DefBuilder withSizeDoc(String sizeDoc) {
            this.sizeDoc = sizeDoc;
            return this;
        }

        public ConfigDef build() {
            this.configDef.define(CacheConfig.CACHE_SIZE_CONFIG, ConfigDef.Type.LONG, this.maybeDefaultSize, ConfigDef.Range.between(-1L, Long.MAX_VALUE), ConfigDef.Importance.MEDIUM, this.sizeDoc);
            this.configDef.define(CacheConfig.CACHE_RETENTION_CONFIG, ConfigDef.Type.LONG, this.defaultRetentionMs, ConfigDef.Range.between(-1L, Long.MAX_VALUE), ConfigDef.Importance.MEDIUM, CacheConfig.CACHE_RETENTION_DOC);
            this.configDef.define(CacheConfig.CACHE_FETCH_THREAD_POOL_SIZE_CONFIG, ConfigDef.Type.INT, 0, ConfigDef.Range.between(0, 1024), ConfigDef.Importance.LOW, CacheConfig.CACHE_FETCH_THREAD_POOL_SIZE_DOC);
            this.configDef.define(CacheConfig.CACHE_FETCH_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, Duration.ofSeconds(10L).toMillis(), ConfigDef.Range.between(1, Long.MAX_VALUE), ConfigDef.Importance.LOW, CacheConfig.CACHE_FETCH_TIMEOUT_MS_DOC);
            return this.configDef;
        }
    }
}

