/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage;

import io.aiven.kafka.tieredstorage.metadata.SegmentCustomMetadataField;
import io.aiven.kafka.tieredstorage.storage.ObjectKey;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;

public final class ObjectKeyFactory {
    private final String prefix;
    private final BiFunction<String, String, ObjectKey> objectKeyConstructor;

    public ObjectKeyFactory(String prefix, boolean maskPrefix) {
        this.prefix = prefix == null ? "" : prefix;
        this.objectKeyConstructor = maskPrefix ? ObjectKeyWithMaskedPrefix::new : PlainObjectKey::new;
    }

    public ObjectKey key(RemoteLogSegmentMetadata remoteLogSegmentMetadata, Suffix suffix) {
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata cannot be null");
        Objects.requireNonNull(suffix, "suffix cannot be null");
        return this.objectKeyConstructor.apply(this.prefix, ObjectKeyFactory.mainPath(remoteLogSegmentMetadata) + "." + suffix.value);
    }

    public ObjectKey key(Map<Integer, Object> fields, RemoteLogSegmentMetadata remoteLogSegmentMetadata, Suffix suffix) {
        Objects.requireNonNull(fields, "fields cannot be null");
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata cannot be null");
        Objects.requireNonNull(suffix, "suffix cannot be null");
        String prefix = (String)fields.getOrDefault(SegmentCustomMetadataField.OBJECT_PREFIX.index(), this.prefix);
        String main = (String)fields.getOrDefault(SegmentCustomMetadataField.OBJECT_KEY.index(), ObjectKeyFactory.mainPath(remoteLogSegmentMetadata));
        return this.objectKeyConstructor.apply(prefix, main + "." + suffix.value);
    }

    public static String mainPath(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = remoteLogSegmentId.topicIdPartition();
        return topicIdPartition.topicPartition().topic() + "-" + String.valueOf(topicIdPartition.topicId()) + "/" + topicIdPartition.topicPartition().partition() + "/" + ObjectKeyFactory.filenamePrefixFromOffset(remoteLogSegmentMetadata.startOffset()) + "-" + String.valueOf(remoteLogSegmentId.id());
    }

    public String prefix() {
        return this.prefix;
    }

    private static String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public static enum Suffix {
        LOG("log"),
        INDEXES("indexes"),
        MANIFEST("rsm-manifest");

        public final String value;

        private Suffix(String value) {
            this.value = value;
        }
    }

    static class ObjectKeyWithMaskedPrefix
    extends PlainObjectKey {
        ObjectKeyWithMaskedPrefix(String prefix, String mainPathAndSuffix) {
            super(prefix, mainPathAndSuffix);
        }

        @Override
        public String toString() {
            return "<prefix>/" + this.mainPathAndSuffix;
        }
    }

    static class PlainObjectKey
    implements ObjectKey {
        protected final String prefix;
        protected final String mainPathAndSuffix;

        PlainObjectKey(String prefix, String mainPathAndSuffix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix cannot be null");
            this.mainPathAndSuffix = Objects.requireNonNull(mainPathAndSuffix, "mainPathAndSuffix cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlainObjectKey that = (PlainObjectKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.mainPathAndSuffix, that.mainPathAndSuffix);
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = 31 * result + this.mainPathAndSuffix.hashCode();
            return result;
        }

        @Override
        public String value() {
            return this.prefix + this.mainPathAndSuffix;
        }

        public String toString() {
            return this.value();
        }
    }
}

