/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage;

import io.aiven.kafka.tieredstorage.storage.BytesRange;

public class Chunk {
    public final int id;
    public final int originalPosition;
    public final int originalSize;
    public final int transformedPosition;
    public final int transformedSize;

    public Chunk(int id, int originalPosition, int originalSize, int transformedPosition, int transformedSize) {
        this.id = id;
        this.originalPosition = originalPosition;
        this.originalSize = originalSize;
        this.transformedPosition = transformedPosition;
        this.transformedSize = transformedSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chunk that = (Chunk)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.originalPosition != that.originalPosition) {
            return false;
        }
        if (this.originalSize != that.originalSize) {
            return false;
        }
        if (this.transformedPosition != that.transformedPosition) {
            return false;
        }
        return this.transformedSize == that.transformedSize;
    }

    public BytesRange range() {
        return BytesRange.ofFromPositionAndSize(this.transformedPosition, this.transformedSize);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.originalPosition;
        result = 31 * result + this.originalSize;
        result = 31 * result + this.transformedPosition;
        result = 31 * result + this.transformedSize;
        return result;
    }

    public String toString() {
        return "Chunk(index=" + this.id + ", originalPosition=" + this.originalPosition + ", originalSize=" + this.originalSize + ", transformedPosition=" + this.transformedPosition + ", transformedSize=" + this.transformedSize + ")";
    }
}

