/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.deser.std;

import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.databind.DeserializationConfig;
import datahub.shaded.jackson.databind.DeserializationContext;
import datahub.shaded.jackson.databind.deser.std.StdDeserializer;
import datahub.shaded.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class NullifyingDeserializer
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    public static final NullifyingDeserializer instance = new NullifyingDeserializer();

    public NullifyingDeserializer() {
        super(Object.class);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.FIELD_NAME)) {
            JsonToken t2;
            while ((t2 = p.nextToken()) != null && t2 != JsonToken.END_OBJECT) {
                p.skipChildren();
            }
        } else {
            p.skipChildren();
        }
        return null;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        switch (p.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(p, ctxt);
            }
        }
        return null;
    }
}

