/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.EditableSchemaFieldInfoArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditableSchemaMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**EditableSchemaMetadata stores editable changes made to schema metadata. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines.*/@Aspect.name=\"editableSchemaMetadata\"record EditableSchemaMetadata includes{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}{/**Client provided a list of fields from document schema.*/editableSchemaFieldInfo:array[/**SchemaField to describe metadata related to dataset schema.*/record EditableSchemaFieldInfo{/**FieldPath uniquely identifying the SchemaField this metadata is associated with*/fieldPath:string/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"editedFieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"EditableSchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"editedFieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"editedFieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"editedFieldTagAttributionDates\",\"fieldType\":\"DATETIME\"},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldTags\",\"fieldType\":\"URN\"}}globalTags:optional{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"EditableSchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"editedFieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"editedFieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"editedFieldTermAttributionDates\",\"fieldType\":\"DATETIME\"},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldGlossaryTerms\",\"fieldType\":\"URN\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"schemaFieldTermsModifiedAt\"}}glossaryTerms:optional{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}}]}", SchemaFormatType.PDL);
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private AuditStamp _deletedField = null;
    private EditableSchemaFieldInfoArray _editableSchemaFieldInfoField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final AuditStamp DEFAULT_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final AuditStamp DEFAULT_LastModified;
    private static final RecordDataSchema.Field FIELD_Deleted;
    private static final RecordDataSchema.Field FIELD_EditableSchemaFieldInfo;

    public EditableSchemaMetadata() {
        super(new DataMap(6, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public EditableSchemaMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCreated();
            }
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            return DEFAULT_Created;
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public EditableSchemaMetadata setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.schema.EditableSchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public EditableSchemaMetadata setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.schema.EditableSchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLastModified();
            }
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            return DEFAULT_LastModified;
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public EditableSchemaMetadata setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.schema.EditableSchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public EditableSchemaMetadata setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.schema.EditableSchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasDeleted() {
        if (this._deletedField != null) {
            return true;
        }
        return this._map.containsKey("deleted");
    }

    public void removeDeleted() {
        this._map.remove("deleted");
    }

    @Nullable
    public AuditStamp getDeleted(GetMode mode) {
        return this.getDeleted();
    }

    @Nullable
    public AuditStamp getDeleted() {
        if (this._deletedField != null) {
            return this._deletedField;
        }
        Object __rawValue = this._map.get("deleted");
        this._deletedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._deletedField;
    }

    public EditableSchemaMetadata setDeleted(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDeleted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDeleted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
            }
        }
        return this;
    }

    public EditableSchemaMetadata setDeleted(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field deleted of com.linkedin.schema.EditableSchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
        this._deletedField = value;
        return this;
    }

    public boolean hasEditableSchemaFieldInfo() {
        if (this._editableSchemaFieldInfoField != null) {
            return true;
        }
        return this._map.containsKey("editableSchemaFieldInfo");
    }

    public void removeEditableSchemaFieldInfo() {
        this._map.remove("editableSchemaFieldInfo");
    }

    @Nullable
    public EditableSchemaFieldInfoArray getEditableSchemaFieldInfo(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEditableSchemaFieldInfo();
            }
            case DEFAULT: 
            case NULL: {
                if (this._editableSchemaFieldInfoField != null) {
                    return this._editableSchemaFieldInfoField;
                }
                Object __rawValue = this._map.get("editableSchemaFieldInfo");
                this._editableSchemaFieldInfoField = __rawValue == null ? null : new EditableSchemaFieldInfoArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._editableSchemaFieldInfoField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public EditableSchemaFieldInfoArray getEditableSchemaFieldInfo() {
        if (this._editableSchemaFieldInfoField != null) {
            return this._editableSchemaFieldInfoField;
        }
        Object __rawValue = this._map.get("editableSchemaFieldInfo");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("editableSchemaFieldInfo");
        }
        this._editableSchemaFieldInfoField = __rawValue == null ? null : new EditableSchemaFieldInfoArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._editableSchemaFieldInfoField;
    }

    public EditableSchemaMetadata setEditableSchemaFieldInfo(@Nullable EditableSchemaFieldInfoArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEditableSchemaFieldInfo(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field editableSchemaFieldInfo of com.linkedin.schema.EditableSchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "editableSchemaFieldInfo", value.data());
                this._editableSchemaFieldInfoField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEditableSchemaFieldInfo();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "editableSchemaFieldInfo", value.data());
                this._editableSchemaFieldInfoField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "editableSchemaFieldInfo", value.data());
                this._editableSchemaFieldInfoField = value;
            }
        }
        return this;
    }

    public EditableSchemaMetadata setEditableSchemaFieldInfo(@Nonnull EditableSchemaFieldInfoArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field editableSchemaFieldInfo of com.linkedin.schema.EditableSchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "editableSchemaFieldInfo", value.data());
        this._editableSchemaFieldInfoField = value;
        return this;
    }

    @Override
    public EditableSchemaMetadata clone() throws CloneNotSupportedException {
        EditableSchemaMetadata __clone = (EditableSchemaMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EditableSchemaMetadata copy() throws CloneNotSupportedException {
        EditableSchemaMetadata __copy = (EditableSchemaMetadata)super.copy();
        __copy._editableSchemaFieldInfoField = null;
        __copy._deletedField = null;
        __copy._createdField = null;
        __copy._lastModifiedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Deleted = SCHEMA.getField("deleted");
        FIELD_EditableSchemaFieldInfo = SCHEMA.getField("editableSchemaFieldInfo");
        DEFAULT_Created = FIELD_Created.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_Created.getDefault(), DataMap.class));
        DEFAULT_LastModified = FIELD_LastModified.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_LastModified.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EditableSchemaMetadata __objectRef;

        private ChangeListener(EditableSchemaMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "editableSchemaFieldInfo": {
                    this.__objectRef._editableSchemaFieldInfoField = null;
                    break;
                }
                case "deleted": {
                    this.__objectRef._deletedField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public AuditStamp.Fields deleted() {
            return new AuditStamp.Fields(this.getPathComponents(), "deleted");
        }

        public EditableSchemaFieldInfoArray.Fields editableSchemaFieldInfo() {
            return new EditableSchemaFieldInfoArray.Fields(this.getPathComponents(), "editableSchemaFieldInfo");
        }

        public PathSpec editableSchemaFieldInfo(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "editableSchemaFieldInfo");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private AuditStamp.ProjectionMask _deletedMask;
        private EditableSchemaFieldInfoArray.ProjectionMask _editableSchemaFieldInfoMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withDeleted(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._deletedMask = nestedMask.apply(this._deletedMask == null ? AuditStamp.createMask() : this._deletedMask);
            this.getDataMap().put("deleted", this._deletedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted(MaskMap nestedMask) {
            this.getDataMap().put("deleted", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted() {
            this._deletedMask = null;
            this.getDataMap().put("deleted", 1);
            return this;
        }

        public ProjectionMask withEditableSchemaFieldInfo(Function<EditableSchemaFieldInfoArray.ProjectionMask, EditableSchemaFieldInfoArray.ProjectionMask> nestedMask) {
            this._editableSchemaFieldInfoMask = nestedMask.apply(this._editableSchemaFieldInfoMask == null ? EditableSchemaFieldInfoArray.createMask() : this._editableSchemaFieldInfoMask);
            this.getDataMap().put("editableSchemaFieldInfo", this._editableSchemaFieldInfoMask.getDataMap());
            return this;
        }

        public ProjectionMask withEditableSchemaFieldInfo() {
            this._editableSchemaFieldInfoMask = null;
            this.getDataMap().put("editableSchemaFieldInfo", 1);
            return this;
        }

        public ProjectionMask withEditableSchemaFieldInfo(Function<EditableSchemaFieldInfoArray.ProjectionMask, EditableSchemaFieldInfoArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._editableSchemaFieldInfoMask = nestedMask.apply(this._editableSchemaFieldInfoMask == null ? EditableSchemaFieldInfoArray.createMask() : this._editableSchemaFieldInfoMask);
            this.getDataMap().put("editableSchemaFieldInfo", this._editableSchemaFieldInfoMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("editableSchemaFieldInfo").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("editableSchemaFieldInfo").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEditableSchemaFieldInfo(Integer start, Integer count) {
            this._editableSchemaFieldInfoMask = null;
            this.getDataMap().put("editableSchemaFieldInfo", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("editableSchemaFieldInfo").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("editableSchemaFieldInfo").put("$count", count);
            }
            return this;
        }
    }
}

