/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.post;

import com.linkedin.common.Media;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.post.PostContentType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostContent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.post/**Content stored inside a Post.*/record PostContent{/**Title of the post.*/@Searchable.fieldType=\"TEXT_PARTIAL\"title:string/**Type of content held in the post.*/type:/**Enum defining the type of content held in a Post.*/enum PostContentType{/**Text content*/TEXT/**Link content*/LINK}/**Optional description of the post.*/description:optional string/**Optional link that the post is associated with.*/link:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}/**Optional media that the post is storing*/media:optional{namespace com.linkedin.common/**Carries information about which roles a user is assigned to.*/record Media{/**Type of content the Media is storing, e.g. image, video, etc.*/type:/**Enum defining the type of content a Media object holds.*/enum MediaType{/**The Media holds an image.*/IMAGE}/**Where the media content is stored.*/location:Url}}}", SchemaFormatType.PDL);
    private String _titleField = null;
    private PostContentType _typeField = null;
    private String _descriptionField = null;
    private Url _linkField = null;
    private Media _mediaField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Title = SCHEMA.getField("title");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Link = SCHEMA.getField("link");
    private static final RecordDataSchema.Field FIELD_Media = SCHEMA.getField("media");

    public PostContent() {
        super(new DataMap(7, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public PostContent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTitle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._titleField != null) {
                    return this._titleField;
                }
                Object __rawValue = this._map.get("title");
                this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._titleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("title");
        }
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public PostContent setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field title of com.linkedin.post.PostContent");
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public PostContent setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.post.PostContent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public PostContentType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PostContentType.class, PostContentType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PostContentType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PostContentType.class, PostContentType.$UNKNOWN);
        return this._typeField;
    }

    public PostContent setType(@Nullable PostContentType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.post.PostContent");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public PostContent setType(@Nonnull PostContentType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.post.PostContent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public PostContent setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public PostContent setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.post.PostContent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasLink() {
        if (this._linkField != null) {
            return true;
        }
        return this._map.containsKey("link");
    }

    public void removeLink() {
        this._map.remove("link");
    }

    @Nullable
    public Url getLink(GetMode mode) {
        return this.getLink();
    }

    @Nullable
    public Url getLink() {
        if (this._linkField != null) {
            return this._linkField;
        }
        Object __rawValue = this._map.get("link");
        this._linkField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._linkField;
    }

    public PostContent setLink(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLink(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLink();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "link", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._linkField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "link", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._linkField = value;
            }
        }
        return this;
    }

    public PostContent setLink(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field link of com.linkedin.post.PostContent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "link", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._linkField = value;
        return this;
    }

    public boolean hasMedia() {
        if (this._mediaField != null) {
            return true;
        }
        return this._map.containsKey("media");
    }

    public void removeMedia() {
        this._map.remove("media");
    }

    @Nullable
    public Media getMedia(GetMode mode) {
        return this.getMedia();
    }

    @Nullable
    public Media getMedia() {
        if (this._mediaField != null) {
            return this._mediaField;
        }
        Object __rawValue = this._map.get("media");
        this._mediaField = __rawValue == null ? null : new Media(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._mediaField;
    }

    public PostContent setMedia(@Nullable Media value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMedia(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMedia();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "media", value.data());
                this._mediaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "media", value.data());
                this._mediaField = value;
            }
        }
        return this;
    }

    public PostContent setMedia(@Nonnull Media value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field media of com.linkedin.post.PostContent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "media", value.data());
        this._mediaField = value;
        return this;
    }

    @Override
    public PostContent clone() throws CloneNotSupportedException {
        PostContent __clone = (PostContent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PostContent copy() throws CloneNotSupportedException {
        PostContent __copy = (PostContent)super.copy();
        __copy._linkField = null;
        __copy._descriptionField = null;
        __copy._mediaField = null;
        __copy._titleField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PostContent __objectRef;

        private ChangeListener(PostContent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "link": {
                    this.__objectRef._linkField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "media": {
                    this.__objectRef._mediaField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec link() {
            return new PathSpec(this.getPathComponents(), "link");
        }

        public Media.Fields media() {
            return new Media.Fields(this.getPathComponents(), "media");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private Media.ProjectionMask _mediaMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withLink() {
            this.getDataMap().put("link", 1);
            return this;
        }

        public ProjectionMask withMedia(Function<Media.ProjectionMask, Media.ProjectionMask> nestedMask) {
            this._mediaMask = nestedMask.apply(this._mediaMask == null ? Media.createMask() : this._mediaMask);
            this.getDataMap().put("media", this._mediaMask.getDataMap());
            return this;
        }

        public ProjectionMask withMedia() {
            this._mediaMask = null;
            this.getDataMap().put("media", 1);
            return this;
        }
    }
}

