/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.mxe;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SystemMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.mxe/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string/**When the aspect was initially created and who created it, detected by version 0 -> 1 change*/aspectCreated:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**When the aspect was last modified and the actor that performed the modification*/aspectModified:optional com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private Long _lastObservedField = null;
    private String _runIdField = null;
    private String _lastRunIdField = null;
    private String _pipelineNameField = null;
    private String _registryNameField = null;
    private String _registryVersionField = null;
    private StringMap _propertiesField = null;
    private String _versionField = null;
    private AuditStamp _aspectCreatedField = null;
    private AuditStamp _aspectModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_LastObserved = SCHEMA.getField("lastObserved");
    private static final Long DEFAULT_LastObserved;
    private static final RecordDataSchema.Field FIELD_RunId;
    private static final String DEFAULT_RunId;
    private static final RecordDataSchema.Field FIELD_LastRunId;
    private static final String DEFAULT_LastRunId;
    private static final RecordDataSchema.Field FIELD_PipelineName;
    private static final RecordDataSchema.Field FIELD_RegistryName;
    private static final RecordDataSchema.Field FIELD_RegistryVersion;
    private static final RecordDataSchema.Field FIELD_Properties;
    private static final RecordDataSchema.Field FIELD_Version;
    private static final RecordDataSchema.Field FIELD_AspectCreated;
    private static final RecordDataSchema.Field FIELD_AspectModified;

    public SystemMetadata() {
        super(new DataMap(14, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public SystemMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasLastObserved() {
        if (this._lastObservedField != null) {
            return true;
        }
        return this._map.containsKey("lastObserved");
    }

    public void removeLastObserved() {
        this._map.remove("lastObserved");
    }

    @Nullable
    public Long getLastObserved(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLastObserved();
            }
            case NULL: {
                if (this._lastObservedField != null) {
                    return this._lastObservedField;
                }
                Object __rawValue = this._map.get("lastObserved");
                this._lastObservedField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._lastObservedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Long getLastObserved() {
        if (this._lastObservedField != null) {
            return this._lastObservedField;
        }
        Object __rawValue = this._map.get("lastObserved");
        if (__rawValue == null) {
            return DEFAULT_LastObserved;
        }
        this._lastObservedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastObservedField;
    }

    public SystemMetadata setLastObserved(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastObserved(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastObserved();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastObserved", DataTemplateUtil.coerceLongInput(value));
                this._lastObservedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastObserved", DataTemplateUtil.coerceLongInput(value));
                this._lastObservedField = value;
            }
        }
        return this;
    }

    public SystemMetadata setLastObserved(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastObserved of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastObserved", DataTemplateUtil.coerceLongInput(value));
        this._lastObservedField = value;
        return this;
    }

    public SystemMetadata setLastObserved(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastObserved", DataTemplateUtil.coerceLongInput(value));
        this._lastObservedField = value;
        return this;
    }

    public boolean hasRunId() {
        if (this._runIdField != null) {
            return true;
        }
        return this._map.containsKey("runId");
    }

    public void removeRunId() {
        this._map.remove("runId");
    }

    @Nullable
    public String getRunId(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getRunId();
            }
            case NULL: {
                if (this._runIdField != null) {
                    return this._runIdField;
                }
                Object __rawValue = this._map.get("runId");
                this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._runIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public String getRunId() {
        if (this._runIdField != null) {
            return this._runIdField;
        }
        Object __rawValue = this._map.get("runId");
        if (__rawValue == null) {
            return DEFAULT_RunId;
        }
        this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._runIdField;
    }

    public SystemMetadata setRunId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRunId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRunId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
            }
        }
        return this;
    }

    public SystemMetadata setRunId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runId of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runId", value);
        this._runIdField = value;
        return this;
    }

    public boolean hasLastRunId() {
        if (this._lastRunIdField != null) {
            return true;
        }
        return this._map.containsKey("lastRunId");
    }

    public void removeLastRunId() {
        this._map.remove("lastRunId");
    }

    @Nullable
    public String getLastRunId(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLastRunId();
            }
            case NULL: {
                if (this._lastRunIdField != null) {
                    return this._lastRunIdField;
                }
                Object __rawValue = this._map.get("lastRunId");
                this._lastRunIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._lastRunIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public String getLastRunId() {
        if (this._lastRunIdField != null) {
            return this._lastRunIdField;
        }
        Object __rawValue = this._map.get("lastRunId");
        if (__rawValue == null) {
            return DEFAULT_LastRunId;
        }
        this._lastRunIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._lastRunIdField;
    }

    public SystemMetadata setLastRunId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastRunId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastRunId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastRunId", value);
                this._lastRunIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastRunId", value);
                this._lastRunIdField = value;
            }
        }
        return this;
    }

    public SystemMetadata setLastRunId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastRunId of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastRunId", value);
        this._lastRunIdField = value;
        return this;
    }

    public boolean hasPipelineName() {
        if (this._pipelineNameField != null) {
            return true;
        }
        return this._map.containsKey("pipelineName");
    }

    public void removePipelineName() {
        this._map.remove("pipelineName");
    }

    @Nullable
    public String getPipelineName(GetMode mode) {
        return this.getPipelineName();
    }

    @Nullable
    public String getPipelineName() {
        if (this._pipelineNameField != null) {
            return this._pipelineNameField;
        }
        Object __rawValue = this._map.get("pipelineName");
        this._pipelineNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._pipelineNameField;
    }

    public SystemMetadata setPipelineName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPipelineName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePipelineName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
            }
        }
        return this;
    }

    public SystemMetadata setPipelineName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pipelineName of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
        this._pipelineNameField = value;
        return this;
    }

    public boolean hasRegistryName() {
        if (this._registryNameField != null) {
            return true;
        }
        return this._map.containsKey("registryName");
    }

    public void removeRegistryName() {
        this._map.remove("registryName");
    }

    @Nullable
    public String getRegistryName(GetMode mode) {
        return this.getRegistryName();
    }

    @Nullable
    public String getRegistryName() {
        if (this._registryNameField != null) {
            return this._registryNameField;
        }
        Object __rawValue = this._map.get("registryName");
        this._registryNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._registryNameField;
    }

    public SystemMetadata setRegistryName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRegistryName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRegistryName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "registryName", value);
                this._registryNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "registryName", value);
                this._registryNameField = value;
            }
        }
        return this;
    }

    public SystemMetadata setRegistryName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field registryName of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "registryName", value);
        this._registryNameField = value;
        return this;
    }

    public boolean hasRegistryVersion() {
        if (this._registryVersionField != null) {
            return true;
        }
        return this._map.containsKey("registryVersion");
    }

    public void removeRegistryVersion() {
        this._map.remove("registryVersion");
    }

    @Nullable
    public String getRegistryVersion(GetMode mode) {
        return this.getRegistryVersion();
    }

    @Nullable
    public String getRegistryVersion() {
        if (this._registryVersionField != null) {
            return this._registryVersionField;
        }
        Object __rawValue = this._map.get("registryVersion");
        this._registryVersionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._registryVersionField;
    }

    public SystemMetadata setRegistryVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRegistryVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRegistryVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "registryVersion", value);
                this._registryVersionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "registryVersion", value);
                this._registryVersionField = value;
            }
        }
        return this;
    }

    public SystemMetadata setRegistryVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field registryVersion of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "registryVersion", value);
        this._registryVersionField = value;
        return this;
    }

    public boolean hasProperties() {
        if (this._propertiesField != null) {
            return true;
        }
        return this._map.containsKey("properties");
    }

    public void removeProperties() {
        this._map.remove("properties");
    }

    @Nullable
    public StringMap getProperties(GetMode mode) {
        return this.getProperties();
    }

    @Nullable
    public StringMap getProperties() {
        if (this._propertiesField != null) {
            return this._propertiesField;
        }
        Object __rawValue = this._map.get("properties");
        this._propertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._propertiesField;
    }

    public SystemMetadata setProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
            }
        }
        return this;
    }

    public SystemMetadata setProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field properties of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
        this._propertiesField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public String getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public String getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._versionField;
    }

    public SystemMetadata setVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
            }
        }
        return this;
    }

    public SystemMetadata setVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value);
        this._versionField = value;
        return this;
    }

    public boolean hasAspectCreated() {
        if (this._aspectCreatedField != null) {
            return true;
        }
        return this._map.containsKey("aspectCreated");
    }

    public void removeAspectCreated() {
        this._map.remove("aspectCreated");
    }

    @Nullable
    public AuditStamp getAspectCreated(GetMode mode) {
        return this.getAspectCreated();
    }

    @Nullable
    public AuditStamp getAspectCreated() {
        if (this._aspectCreatedField != null) {
            return this._aspectCreatedField;
        }
        Object __rawValue = this._map.get("aspectCreated");
        this._aspectCreatedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aspectCreatedField;
    }

    public SystemMetadata setAspectCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspectCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspectCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspectCreated", value.data());
                this._aspectCreatedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspectCreated", value.data());
                this._aspectCreatedField = value;
            }
        }
        return this;
    }

    public SystemMetadata setAspectCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspectCreated of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspectCreated", value.data());
        this._aspectCreatedField = value;
        return this;
    }

    public boolean hasAspectModified() {
        if (this._aspectModifiedField != null) {
            return true;
        }
        return this._map.containsKey("aspectModified");
    }

    public void removeAspectModified() {
        this._map.remove("aspectModified");
    }

    @Nullable
    public AuditStamp getAspectModified(GetMode mode) {
        return this.getAspectModified();
    }

    @Nullable
    public AuditStamp getAspectModified() {
        if (this._aspectModifiedField != null) {
            return this._aspectModifiedField;
        }
        Object __rawValue = this._map.get("aspectModified");
        this._aspectModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aspectModifiedField;
    }

    public SystemMetadata setAspectModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspectModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspectModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspectModified", value.data());
                this._aspectModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspectModified", value.data());
                this._aspectModifiedField = value;
            }
        }
        return this;
    }

    public SystemMetadata setAspectModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspectModified of com.linkedin.mxe.SystemMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspectModified", value.data());
        this._aspectModifiedField = value;
        return this;
    }

    @Override
    public SystemMetadata clone() throws CloneNotSupportedException {
        SystemMetadata __clone = (SystemMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SystemMetadata copy() throws CloneNotSupportedException {
        SystemMetadata __copy = (SystemMetadata)super.copy();
        __copy._pipelineNameField = null;
        __copy._aspectCreatedField = null;
        __copy._lastObservedField = null;
        __copy._registryVersionField = null;
        __copy._lastRunIdField = null;
        __copy._aspectModifiedField = null;
        __copy._runIdField = null;
        __copy._registryNameField = null;
        __copy._versionField = null;
        __copy._propertiesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_RunId = SCHEMA.getField("runId");
        FIELD_LastRunId = SCHEMA.getField("lastRunId");
        FIELD_PipelineName = SCHEMA.getField("pipelineName");
        FIELD_RegistryName = SCHEMA.getField("registryName");
        FIELD_RegistryVersion = SCHEMA.getField("registryVersion");
        FIELD_Properties = SCHEMA.getField("properties");
        FIELD_Version = SCHEMA.getField("version");
        FIELD_AspectCreated = SCHEMA.getField("aspectCreated");
        FIELD_AspectModified = SCHEMA.getField("aspectModified");
        DEFAULT_LastObserved = DataTemplateUtil.coerceLongOutput(FIELD_LastObserved.getDefault());
        DEFAULT_RunId = DataTemplateUtil.coerceStringOutput(FIELD_RunId.getDefault());
        DEFAULT_LastRunId = DataTemplateUtil.coerceStringOutput(FIELD_LastRunId.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SystemMetadata __objectRef;

        private ChangeListener(SystemMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "pipelineName": {
                    this.__objectRef._pipelineNameField = null;
                    break;
                }
                case "aspectCreated": {
                    this.__objectRef._aspectCreatedField = null;
                    break;
                }
                case "lastObserved": {
                    this.__objectRef._lastObservedField = null;
                    break;
                }
                case "registryVersion": {
                    this.__objectRef._registryVersionField = null;
                    break;
                }
                case "lastRunId": {
                    this.__objectRef._lastRunIdField = null;
                    break;
                }
                case "aspectModified": {
                    this.__objectRef._aspectModifiedField = null;
                    break;
                }
                case "runId": {
                    this.__objectRef._runIdField = null;
                    break;
                }
                case "registryName": {
                    this.__objectRef._registryNameField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "properties": {
                    this.__objectRef._propertiesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec lastObserved() {
            return new PathSpec(this.getPathComponents(), "lastObserved");
        }

        public PathSpec runId() {
            return new PathSpec(this.getPathComponents(), "runId");
        }

        public PathSpec lastRunId() {
            return new PathSpec(this.getPathComponents(), "lastRunId");
        }

        public PathSpec pipelineName() {
            return new PathSpec(this.getPathComponents(), "pipelineName");
        }

        public PathSpec registryName() {
            return new PathSpec(this.getPathComponents(), "registryName");
        }

        public PathSpec registryVersion() {
            return new PathSpec(this.getPathComponents(), "registryVersion");
        }

        public PathSpec properties() {
            return new PathSpec(this.getPathComponents(), "properties");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public AuditStamp.Fields aspectCreated() {
            return new AuditStamp.Fields(this.getPathComponents(), "aspectCreated");
        }

        public AuditStamp.Fields aspectModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "aspectModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _aspectCreatedMask;
        private AuditStamp.ProjectionMask _aspectModifiedMask;

        ProjectionMask() {
            super(14);
        }

        public ProjectionMask withLastObserved() {
            this.getDataMap().put("lastObserved", 1);
            return this;
        }

        public ProjectionMask withRunId() {
            this.getDataMap().put("runId", 1);
            return this;
        }

        public ProjectionMask withLastRunId() {
            this.getDataMap().put("lastRunId", 1);
            return this;
        }

        public ProjectionMask withPipelineName() {
            this.getDataMap().put("pipelineName", 1);
            return this;
        }

        public ProjectionMask withRegistryName() {
            this.getDataMap().put("registryName", 1);
            return this;
        }

        public ProjectionMask withRegistryVersion() {
            this.getDataMap().put("registryVersion", 1);
            return this;
        }

        public ProjectionMask withProperties() {
            this.getDataMap().put("properties", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withAspectCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._aspectCreatedMask = nestedMask.apply(this._aspectCreatedMask == null ? AuditStamp.createMask() : this._aspectCreatedMask);
            this.getDataMap().put("aspectCreated", this._aspectCreatedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspectCreated(MaskMap nestedMask) {
            this.getDataMap().put("aspectCreated", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspectCreated() {
            this._aspectCreatedMask = null;
            this.getDataMap().put("aspectCreated", 1);
            return this;
        }

        public ProjectionMask withAspectModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._aspectModifiedMask = nestedMask.apply(this._aspectModifiedMask == null ? AuditStamp.createMask() : this._aspectModifiedMask);
            this.getDataMap().put("aspectModified", this._aspectModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspectModified(MaskMap nestedMask) {
            this.getDataMap().put("aspectModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspectModified() {
            this._aspectModifiedMask = null;
            this.getDataMap().put("aspectModified", 1);
            return this;
        }
    }
}

