/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Metrics
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Metrics to be featured for the MLModel.*/@Aspect.name=\"mlModelMetrics\"record Metrics{/**Measures of MLModel performance*/performanceMeasures:optional array[string]/**Decision Thresholds used (if any)?*/decisionThreshold:optional array[string]}", SchemaFormatType.PDL);
    private StringArray _performanceMeasuresField = null;
    private StringArray _decisionThresholdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_PerformanceMeasures = SCHEMA.getField("performanceMeasures");
    private static final RecordDataSchema.Field FIELD_DecisionThreshold = SCHEMA.getField("decisionThreshold");

    public Metrics() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public Metrics(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPerformanceMeasures() {
        if (this._performanceMeasuresField != null) {
            return true;
        }
        return this._map.containsKey("performanceMeasures");
    }

    public void removePerformanceMeasures() {
        this._map.remove("performanceMeasures");
    }

    @Nullable
    public StringArray getPerformanceMeasures(GetMode mode) {
        return this.getPerformanceMeasures();
    }

    @Nullable
    public StringArray getPerformanceMeasures() {
        if (this._performanceMeasuresField != null) {
            return this._performanceMeasuresField;
        }
        Object __rawValue = this._map.get("performanceMeasures");
        this._performanceMeasuresField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._performanceMeasuresField;
    }

    public Metrics setPerformanceMeasures(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPerformanceMeasures(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePerformanceMeasures();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "performanceMeasures", value.data());
                this._performanceMeasuresField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "performanceMeasures", value.data());
                this._performanceMeasuresField = value;
            }
        }
        return this;
    }

    public Metrics setPerformanceMeasures(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field performanceMeasures of com.linkedin.ml.metadata.Metrics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "performanceMeasures", value.data());
        this._performanceMeasuresField = value;
        return this;
    }

    public boolean hasDecisionThreshold() {
        if (this._decisionThresholdField != null) {
            return true;
        }
        return this._map.containsKey("decisionThreshold");
    }

    public void removeDecisionThreshold() {
        this._map.remove("decisionThreshold");
    }

    @Nullable
    public StringArray getDecisionThreshold(GetMode mode) {
        return this.getDecisionThreshold();
    }

    @Nullable
    public StringArray getDecisionThreshold() {
        if (this._decisionThresholdField != null) {
            return this._decisionThresholdField;
        }
        Object __rawValue = this._map.get("decisionThreshold");
        this._decisionThresholdField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._decisionThresholdField;
    }

    public Metrics setDecisionThreshold(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDecisionThreshold(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDecisionThreshold();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "decisionThreshold", value.data());
                this._decisionThresholdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "decisionThreshold", value.data());
                this._decisionThresholdField = value;
            }
        }
        return this;
    }

    public Metrics setDecisionThreshold(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field decisionThreshold of com.linkedin.ml.metadata.Metrics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "decisionThreshold", value.data());
        this._decisionThresholdField = value;
        return this;
    }

    @Override
    public Metrics clone() throws CloneNotSupportedException {
        Metrics __clone = (Metrics)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Metrics copy() throws CloneNotSupportedException {
        Metrics __copy = (Metrics)super.copy();
        __copy._decisionThresholdField = null;
        __copy._performanceMeasuresField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Metrics __objectRef;

        private ChangeListener(Metrics reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "decisionThreshold": {
                    this.__objectRef._decisionThresholdField = null;
                    break;
                }
                case "performanceMeasures": {
                    this.__objectRef._performanceMeasuresField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec performanceMeasures() {
            return new PathSpec(this.getPathComponents(), "performanceMeasures");
        }

        public PathSpec performanceMeasures(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "performanceMeasures");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec decisionThreshold() {
            return new PathSpec(this.getPathComponents(), "decisionThreshold");
        }

        public PathSpec decisionThreshold(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "decisionThreshold");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withPerformanceMeasures() {
            this.getDataMap().put("performanceMeasures", 1);
            return this;
        }

        public ProjectionMask withPerformanceMeasures(Integer start, Integer count) {
            this.getDataMap().put("performanceMeasures", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("performanceMeasures").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("performanceMeasures").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDecisionThreshold() {
            this.getDataMap().put("decisionThreshold", 1);
            return this;
        }

        public ProjectionMask withDecisionThreshold(Integer start, Integer count) {
            this.getDataMap().put("decisionThreshold", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("decisionThreshold").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("decisionThreshold").put("$count", count);
            }
            return this;
        }
    }
}

