/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.metadata.utils.metrics.MetricUtils;

public class ExceptionUtils {
    private static final String BASE_NAME = "metadata.validation.exception";
    private static final String DELIMITER = ".";

    private ExceptionUtils() {
    }

    public static ValidationExceptionCollection collectMetrics(MetricUtils metricUtils, ValidationExceptionCollection exceptions) {
        if (metricUtils != null) {
            exceptions.streamAllExceptions().forEach(exception -> {
                String subTypeBaseName = String.join((CharSequence)DELIMITER, BASE_NAME, exception.getSubType().toString().toLowerCase());
                metricUtils.increment(subTypeBaseName, exceptions.size());
                metricUtils.increment(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getChangeType().toString().toLowerCase()), 1.0);
                metricUtils.increment(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getEntityUrn().getEntityType().toLowerCase()), 1.0);
                metricUtils.increment(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getAspectName()), 1.0);
            });
        }
        return exceptions;
    }
}

